/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC30F6910
;  *   	@             : 2021.08.04
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *    ϵEEַд;ٶȡж
   	   	ȫȷP10Dߣ 
******************************************************************************/
#include    "user.h"

/************************************************
;  *    @Function Name       : CLR_RAN
;  *    @Description         : ʼRAM
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/

const u8 EEPROM_test_num[10]={0x12,0x23,0x34,0x45,0x56,0x67,0x78,0x89,0x9A,0xAB};
u8 EEPROM_test_buff[10];
void  CLR_RAM(void)
{
    for(FSR = 0xBF; FSR > 0x8F ; FSR--)
    {
        INDF = 0;
    }
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IO
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void  IO_Init(void)
{
    P1 = 0x00;
    DDR1 = 0x00;    // 1:input 0:output
    PUCON1 = 0xff;  // 0:Effective 1:invalid
    PDCON1 = 0xff;  // 0:Effective 1:invalid
    ODCON1 = 0x00;  //0:  1:© 

}


/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void  Sys_Init(void)
{
       GIE = 0;
       CLR_RAM();
       IO_Init();
       GIE = 1; 
}

/************************************************
;  *    @Function Name       : EEWrite_1Byte
;  *    @Description         : EEдһֽ
;  *    @IN_Parameter        : ַ   
;  *    @Return parameter    :
;  ***********************************************/
void  EEWrite_1Byte(u8 Write_addr,u8 Write_data)
{  
        EEAR = Write_addr;      //ַдEEAR
        EEDR = Write_data;      //дEEDR
        GIE = 0;
        EEPR = 0x5A;
        EEPR = 0xA5;    //
        EECR = 0x01;    //EEд
        Nop();
        Nop();
        GIE = 1;
        Nop();
}

/************************************************
;  *    @Function Name       : EERead_1Byte
;  *    @Description         : EEȡһֽ
;  *    @IN_Parameter        : ַ
;  *    @Return parameter    : ȡ
;  ***********************************************/
unsigned char  EERead_1Byte(u8 read_addr)
{
        
        EEAR = read_addr;   //ַдEEAR
        EECR = 0x02;    //EE
        Nop();
        Nop();        
        return  EEDR;   //ضȡֵ

}

/************************************************
;  *    @Function Name       : EEPROM_Write_Data
;  *    @Description         : 
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void  EEPROM_Write_Data(u8 Write_addr,u8 *Write_data,u8 len)
{
        while(len)
        {
           EEWrite_1Byte(Write_addr++,*Write_data++); 
           len--;  
        }
}


/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void  main(void)
{
    Sys_Init();
    EEPROM_Write_Data(0,EEPROM_test_num,10);    //д
    for(R_Count=0;R_Count<10;R_Count++)
    {
        EEPROM_test_buff[R_Count] = EERead_1Byte(R_Count);  //ȡ
    }
    
    if((EEPROM_test_buff[0]==0x12)&&(EEPROM_test_buff[1]==0x23)&&(EEPROM_test_buff[2]==0x34)
    &&(EEPROM_test_buff[3]==0x45)&&(EEPROM_test_buff[4]==0x56)&&(EEPROM_test_buff[5]==0x67)
    &&(EEPROM_test_buff[6]==0x78)&&(EEPROM_test_buff[7]==0x89)&&(EEPROM_test_buff[8]==0x9A)
    &&(EEPROM_test_buff[9]==0xAB))
    {
        P10D = 1;
    }
    else
    {
        P10D = 0;
    }
    while(1)
    {

    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void  int_isr(void) __interrupt
{
   	__asm
   	movra   _abuf
    swapar  _STATUS
    movra   _statusbuf
__endasm;



__asm
   	swapar  _statusbuf
    movra   _STATUS
    swapr   _abuf
    swapar  _abuf
__endasm;

}

/**************************** end of file *********************************************/