/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC32P8114
;  *   	@             : 2021.08.04
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	P10ⲿж½شP15ת      	   	                                           	   	
******************************************************************************/
#include    "user.h"

/************************************************
;  *    @Function Name       : CLR_RAN
;  *    @Description         : ʼRAM
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/

void  CLR_RAM(void)
{
    for(FSR = 0xBF; FSR > 0x8F ; FSR--)
    {
        INDF = 0;
    }
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IO
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void  IO_Init(void)
{
    P1 = 0x00;
    DDR1 = 0x00;    // 1:input 0:output
    PUCON1 = 0xff;  // 0:Effective 1:invalid
    PDCON1 = 0xff;  // 0:Effective 1:invalid
    ODCON1 = 0x00;  //0:  1:© 

}

/************************************************
;  *    @Function Name       : INT_Init
;  *    @Description         : ⲿжϳʼ
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void  INT_Init(void)
{
        INTM = 0;       //½ش
        
        P1 = 0x01;      //P10
        DDR1 = 0x01;
        PUCON1 = 0xfe;

   	    EIS=1;     	   	   	//ⲿжԴЧ
   	    INTIE=1;   	   	   	//ⲿжʹ

}

/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void  Sys_Init(void)
{
       GIE = 0;
       CLR_RAM();
       IO_Init();
       INT_Init();
       GIE = 1; 
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void  main(void)
{
    Sys_Init();
    while(1)
    {
        
    }

}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void  int_isr(void) __interrupt
{
   	__asm
   	movra   _abuf
    swapar  _STATUS
    movra   _statusbuf
__endasm;

   	if((INTIF)&&(INTIE))
   	{
   	   	P15D=!P15D;
   	   	INTIF=0;
   	}

__asm
   	swapar  _statusbuf
    movra   _STATUS
    swapr   _abuf
    swapar  _abuf
__endasm;

}

/**************************** end of file *********************************************/