/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC30F6910
;  *   	@             : 2021.08.04
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *    T0ʱ5sһ P10жϻ
;  *   	P11ж1mSת
******************************************************************************/
#include    "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            :
;  *    @        :
;  *    @ز        :
;  ***********************************************/

void  CLR_RAM(void)
{
    for(FSR = 0xBF; FSR > 0x8F ; FSR--)
    {
        INDF = 0;
    }
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void  IO_Init(void)
{
    P1 = 0x00;
    DDR1 = 0x00;    // 1:input 0:output
    PUCON1 = 0xff;  // 0:Effective 1:invalid
    PDCON1 = 0xff;  // 0:Effective 1:invalid
    ODCON1 = 0x00;  //0:  1:© 

}

/************************************************
;  *    @            : KBIE_Init
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void  KBIE_Init(void)
{
        DDR1 |= DEF_SET_BIT0;   //P10  in
        PUCON1 &= ~DEF_SET_BIT0;   	//P10
        P1KBCR |= DEF_SET_BIT0;    	//ʹP10ļжλ
}

/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱT0
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
   	    T0CR = 0x05; //ʱΪCPUʱ    ʱ64Ƶ  1ms
   	    T0CNT = 256 - 125;
       	T0IE = 1;

}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void  Sys_Init(void)
{
       GIE = 0;
       CLR_RAM();
       IO_Init();
       KBIE_Init();
       TIMER0_INT_Init();
       GIE = 1; 
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void  main(void)
{
    Sys_Init();
    while(1)
    {
        if(FLAG_TIMER0_5000ms)
   	   	{
   	   	   	FLAG_TIMER0_5000ms=0;
   	   	   	GIE = 0;
   	   	   	KBIF=0;
   	   	   	KBIE = 1;
   	   	   	P11D = 0;
   	       	Stop();
   	   	   	Nop();
   	   	   	Nop();
   	   	   	KBIE = 0;
   	   	   	KBIF = 0;
   	   	   	GIE = 1;   	   	
   	   	}  
    }

}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void  int_isr(void) __interrupt
{
   	__asm
   	movra   _abuf
    swapar  _STATUS
    movra   _statusbuf
__endasm;

   	if((T0IF)&&(T0IE))
    {
   	   	T0CNT=131;
   	   	P11D=!P11D;
   	   	timer0_count1++;
   	   	if(timer0_count1>=5000)
   	   	{
   	   	   	timer0_count1=0;
   	   	   	FLAG_TIMER0_5000ms=1;      	   	   	
   	   	}
   	   	T0IF=0;
    }

__asm
   	swapar  _statusbuf
    movra   _STATUS
    swapr   _abuf
    swapar  _abuf
__endasm;

}

/**************************** end of file *********************************************/