/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                  ADC 
;  *                  ϵȴADȶУ׼
;  *                  ADCʱΪHIRC 16Ƶ1M12λH8L4ڲ2V15ADCLK
;  *                  ʱ2msP13D ɼѹֵ 
;  *                  ɼѹֵ<1.5V:P03DΪ͵ƽ;>1.5V:P03DΪߵƽ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @            : delay
;  *    @˵              : ȷʱ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void delay(uint16_t num)
{
    for (i = 0; i < num; i ++)
    {
        Nop();
    }
}
/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0 ++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x03;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @            : ADC_Power_On_Stability
;  *    @˵              : ADCϵȶ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void ADC_Power_On_Stability(void)
{
    uint8_t cnt;
    ADCR0 = 0xf7;                      //ʹADCVDD/4ͨ,رձȽڲοѹ,οѹVDD
    ADCR1 = 0x13;                      //16Ƶ8λ4λʱ̶15ADCLK
    ADEOC = 0;
    while (!ADEOC);
    cnt = 0;
    while (!(((ADRH >> 2) == 0x10) || ((ADRH >> 2) == 0x0F)))
    {
        ADEOC = 0;
        while (!ADEOC);
        cnt ++;
        if (cnt >= 200)
            return;                    //ûӷֵ,ʾ
    }
}
/************************************************
;  *    @            : ADC_Zero_ADJ
;  *    @˵              : ADCУ׼
;  *    @          :
;  *    @ز          :0 У׼ɹ  1У׼ʧ
;  *    ûѡǷУ׼
;  ***********************************************/
uint8_t ADC_Zero_ADJ(void)
{
    ADCR0 = 0xe3;                                //ʹADCرձȽڲοѹGNDͨ
    ADCR1 = 0x13;                                //16Ƶ8λ4λʱ̶15ADCLK
    MEFCR = 0x02;                                //ڲ2V
    OSADJCR |= DEF_SET_BIT7;                     //ʹУ׼޵
    ADEOC = 0;
    while (!ADEOC);
    if ((ADRH == 0) && ((ADRL & 0x0F) == 0))     //ǷΪ0
    {
        OSADJTD = 1;                             //޵
        OSADJCR |= 0x1F;
        ADEOC = 0;
        while (!ADEOC);
        if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) //ǷΪ0
        {
            ADEN = 0;
            return PASS;
        }
        else
        {
            while (1)
            {
                if (OSADJCR & 0x1f)
                {
                    OSADJCR --;
                    ADEOC = 0;
                    while (!ADEOC);
                    if ((ADRH == 0) && ((ADRL & 0x0F) == 0))//ǷΪ0
                    {
                        ADEN = 0;
                        return PASS;
                    }
                }
                else
                {
                    ADEN = 0;
                    return FAIL;
                }
            }
        }
    }
    else
    {
        while (1)
        {
            if ((OSADJCR & 0x1f) == 0x1f)
            {
                ADEN = 0;
                return FAIL;
            }
            else
            {
                OSADJCR ++;
                ADEOC = 0;
                while (!ADEOC);
                if ((ADRH == 0) && ((ADRL & 0x0F) == 0))//ǷΪ0
                {
                    ADEN = 0;
                    return PASS;
                }
            }
        }
    }
}
/************************************************
;  *    @            : ADC_Init
;  *    @˵              : ADCʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void ADC_Init(void)
{
    OEP1 &= DEF_CLR_BIT3;                        //P13Ϊ
    P1ADCR |= DEF_SET_BIT3;                      //ʹP13ģ⹦
    ADCR0 = 0x63;                                //ʹADCرձȽڲοѹ
    ADCR1 = 0x13;                                //16Ƶ8λ4λʱ̶15ADCLK
    MEFCR = 0x02;                                //ڲ2V
}
/************************************************
;  *    @            : ADC_Get_Value_Average
;  *    @˵              : ת
;  *    @          : ͨ
;  *    @ز          : ADCֵ
;  *    ռڴϴ        
;  ***********************************************/
uint ADC_Get_Value_Average(u8 CHX)
{
    g_temp_value = 0;
    g_channel = 0;
    g_tmpbuff = 0;
    g_adcmax = 0;
    g_adcmin = 0xffff;
    ADCR0 = (ADCR0 & 0x0f) | (CHX << 4);         // ADC ʹ  ADתͨ  ͨ  CHX
    delay(300);                                  //лͨʱ200uS
    for (g_channel = 0; g_channel < 20; g_channel ++)
    {
        ADEOC = 0;
        while (!ADEOC);                          //ȴת
        g_temp_value = ADRH;
        g_temp_value = g_temp_value << 4 | (ADRL & 0x0f);
        if (g_channel < 2)
            continue;                            //ǰβ
        if (g_temp_value > g_adcmax)
            g_adcmax = g_temp_value;             //
        if (g_temp_value < g_adcmin)
            g_adcmin = g_temp_value;             //С
        g_tmpbuff += g_temp_value;
    }
    g_tmpbuff -= g_adcmax;                       //ȥһ
    g_tmpbuff -= g_adcmin;                       //ȥһС
    g_temp_value = (g_tmpbuff >> 4);             //16ȡƽֵ
    return g_temp_value;
}
/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR |= DEF_SET_BIT1 | DEF_SET_BIT2;         //CPU,64Ƶ
    T0CNT = 250-1;
    T0LOAD = 250-1;                              //2ms
    T0EN = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    ADC_Power_On_Stability();
    while (ADC_Zero_ADJ());                      //demoʾ,У׼ʧһֱУ׼ûѡǷУ׼
    ADC_Init();
    TIMER0_INT_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if (T0IF)                                //2mS
        {
            T0IF = 0;
            g_adc_value0_temp = ADC_Get_Value_Average(6);
        }
        if (g_adc_value0_temp > 2048+1024)       //>1.5V
        {
            P03D = 1;
        }
        else
        {
            P03D = 0;
        }
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
