/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *            ΪMC32F7132_IIC_Master(ģ)
;  *            ȴӻϵϵ
;  *            SDAP02  SCLP00
;  *            ͨѶַ0x40  MC32F7132_IIC_Slave(Ӳӻ)MC32F7132_IIC_Master(ģ)ͨѶ
;  *            ӻ͵ַ1(20byte0x40ַ)Ȼԭ(20byte)
;  *            ʹPDT1(P12)PCK1(P14)Կ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0 ++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @          : Delay
;  *    @˵            : ȷʱ
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void Delay_us(u16 num)
{
    while(num)
    {
        num--;
    }
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x05;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x03;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @Function Name       : IIC_Start
;  *    @Description         : IICʼź
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void IIC_Start(u8 R_Slave_addr)
{
    SDA_OUT();              //ģʽ
    IIC_SCL = 1;
    IIC_SDA = 1;
    Delay_us(4);            //ʱ7us  
    IIC_SDA = 0;
    Delay_us(4);            //ʱ7us
    IIC_SCL = 0;

    for (IIC_Start_num = 0; IIC_Start_num < 8; IIC_Start_num++)
    {
        IIC_SDA = (R_Slave_addr & 0x80) >> 7;
        R_Slave_addr <<= 1;
        Delay_us(4);        //ʱ7us
        IIC_SCL=1;
        Delay_us(4);        //ʱ7us
        IIC_SCL=0;
        Delay_us(4);        //ʱ7us
    }
}
/************************************************
;  *    @Function Name       : IIC_Stop
;  *    @Description         : IICֹͣź
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void IIC_Stop(void)
{
    SDA_OUT();              //ģʽ
    IIC_SCL = 0;
    IIC_SDA = 0;
    Delay_us(4);            //ʱ7us
    IIC_SCL = 1;
    IIC_SDA = 1;            //I2C߽ź
    Delay_us(4);            //ʱ7us
}

/************************************************
;  *    @Function Name       : IIC_ACK
;  *    @Description         : ACKӦ
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void IIC_ACK(void)
{
    IIC_SCL = 0;
    SDA_OUT();              //ģʽ
    IIC_SDA = 0;
    Delay_us(4);            //ʱ7us
    IIC_SCL = 1;
    Delay_us(4);            //ʱ7us
    IIC_SCL = 0;
}

/************************************************
;  *    @Function Name       : IIC_NACK
;  *    @Description         : ACKӦ
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void IIC_NACK(void)
{
    IIC_SCL = 0;
    SDA_OUT();              //ģʽ
    IIC_SDA = 1;
    Delay_us(4);            //ʱ7us
    IIC_SCL = 1;
    Delay_us(4);            //ʱ7us
    IIC_SCL = 0;
}
/************************************************
;  *    @            : IIC_Recive_Byte
;  *    @˵              : IICӻȡһֽ
;  *    @          :
;  *    @ز          : temp-ǰȡ
;  ***********************************************/
u8 IIC_Recive_Byte(void)
{
    IIC_Recive_num++;
    SDA_IN();               // SDAΪ
    for(i = 0; i < 8; i++)
    {
        IIC_SCL = 0;
        Delay_us(4);        //ʱ7us
        IIC_SCL = 1;
        receive <<= 1;
        if(IIC_SDA)
        {
            receive++;      //IIC_SDA!= 0
        }
        Delay_us(4);        //ʱ7us
    }
    if(IIC_Recive_num<20)
        IIC_ACK();          //ACK
    else
        IIC_NACK();         //nACK
    return receive;
}

/************************************************
;  *    @Function Name       : IIC_host_Write_Byte
;  *    @Description         : д
;  *    @IN_Parameter           : 
;  *    @Return parameter    : 
;  ***********************************************/
void IIC_host_Write_Byte()
{
    IIC_SDA = 1;
    SDA_OUT();
    IIC_SCL = 0;        //ʱӿʼݴ
    sead_data = g_iic_buff_data[IIC_host_Write_num];
    for(t = 0; t < 8; t++)
    {
        if((sead_data & 0x80)>>7)
            IIC_SDA = 1;
        else
            IIC_SDA = 0;
        sead_data <<= 1;
        Delay_us(4);    //ʱ7us
        IIC_SCL = 1;
        Delay_us(4);    //ʱ7us
        IIC_SCL = 0;
        Delay_us(4);    //ʱ7us
    }
}

/************************************************
;  *    @Function Name       : IIC_Wait_ACK
;  *    @Description         : ȴӦźŵ
;  *    @IN_Parameter           : 
;  *    @Return parameter    : 0Ӧɹ 1Ӧʧ
;  ***********************************************/
u8 IIC_Wait_ACK(void)
{
    u8 ucErrTime = 0;
    SDA_IN();           //SDAΪ
    IIC_SCL = 1;
    Delay_us(4);        //ʱ7us
    IIC_SCL = 0;        //ʱ0
    while (IIC_SDA)
    {
        ucErrTime++;
        if (ucErrTime > 250)
        {
            IIC_Stop();
            return 1;
        }
    }
    IIC_SCL = 0;        //ʱ0
    return 0;
}
/************************************************
;  *    @Function Name       : IIC_host_Read_Len_Byte
;  *    @Description         : 
;  *    @IN_Parameter           : ֵַ  
;  *    @Return parameter    : 
;  ***********************************************/
void IIC_host_Read_Len_Byte(u8 *data,u8 len)
{
    IIC_Start(0x41);            //õַΪ40 
    if(IIC_Wait_ACK()==0)       //ȴӦź
    {
        while(len)
        {
            *data = IIC_Recive_Byte();
            data++;
            len--;
            Delay_us(100);      //ʱ140us
        }
    }
    IIC_Stop();
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();                     //ʼ
    IIC_Recive_num = 0;
    IIC_host_Read_Len_Byte(g_iic_buff_data,IIC_DATA_LEN);   //20byteݴ0x40ַ
    Delay_us(100);                  //ʱ140us
    IIC_Start(0x40);                //õַΪ40 
    if(IIC_Wait_ACK()==0)           //ȴӦź
    {
        for(IIC_host_Write_num = 0; IIC_host_Write_num < 20; IIC_host_Write_num++)
        {
            IIC_host_Write_Byte();  //д20byte
            IIC_Wait_ACK();         //ȴӦź
            Delay_us(100);          //ʱ140us
        }
        IIC_Stop();
    }
    while (1)
    {
        Nop();
    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

    
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/