/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                   ʱʹȫֱ                       
******************************************************************************/
#ifndef USER
#define USER
#include "mc32-common.h"
#include "MC32F7132.h"

/*****************************************************************
;       Function : Define variables
;*****************************************************************/
#define u8 unsigned char
#define u16 unsigned int
#define u32 unsigned long int
#define uint8_t  unsigned char
#define uint16_t unsigned int
#define uint32_t unsigned long int

#define DEF_SET_BIT0        0x01
#define DEF_SET_BIT1        0x02
#define DEF_SET_BIT2        0x04
#define DEF_SET_BIT3        0x08
#define DEF_SET_BIT4        0x10
#define DEF_SET_BIT5        0x20
#define DEF_SET_BIT6        0x40
#define DEF_SET_BIT7        0x80

#define DEF_CLR_BIT0        0xFE
#define DEF_CLR_BIT1        0xFD
#define DEF_CLR_BIT2        0xFB
#define DEF_CLR_BIT3        0xF7
#define DEF_CLR_BIT4        0xEF
#define DEF_CLR_BIT5        0xDF
#define DEF_CLR_BIT6        0xBF
#define DEF_CLR_BIT7        0x7F

#define IIC_DATA_LEN        20
#define FAIL                0
#define PASS                1

#define SDA_IN()            OEP0 &= 0b11111011;
#define SDA_OUT()           OEP0  = 0b11111111;

#define IIC_SDA             P02D
#define IIC_SCL             P00D

//===============Field Protection Variables===============
u8 abuf;
u8 statusbuf,i,temp,addr_data;
u8 IIC_Start_num,IIC_Recive_num,receive,IIC_host_Write_num,t,sead_data;
__at 0x40 u8 g_iic_buff_data[IIC_DATA_LEN];
//===============Global Function===============
void Sys_Init(void);
void CLR_RAM(void);
void IO_Init(void);
void IIC_host_Init(void);
void IIC_host_Start(void);
void IIC_host_Write_Byte(void);
u8 IIC_host_Recive_Byte(void);
u8 Data_host_Comparison(u8 *data1,u8 *data2,u8 len);
//============Define  Flag=================
typedef union {
    unsigned char byte;
    struct
    {
        u8 bit0 : 1;
        u8 bit1 : 1;
        u8 bit2 : 1;
        u8 bit3 : 1;
        u8 bit4 : 1;
        u8 bit5 : 1;
        u8 bit6 : 1;
        u8 bit7 : 1;
    } bits;
}bit_flag;
volatile bit_flag flag1;

#define     FLAG_IIC_DONE    flag1.bits.bit0  
#define     FLAG_IIC_START   flag1.bits.bit1  
#define     FLAG_Write       flag1.bits.bit2  
#define     FLAG_Recive      flag1.bits.bit3 

#endif

/**************************** end of file *********************************************/