/******************************************************************************
;  *       @ͺ                 : MC32F7132
;  *       @             : 2023.01.04
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢Ȩ.
;  *----------------------ժҪ---------------------------------
;  *               ʱ0--PWM0
;  *               P15DΣF=10k,D=25%                                             
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for (FSR0 = 0; FSR0 < 0xff; FSR0++)
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
}
/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;                       //ioλ
    OEP0 = 0xFF;                       //ioڷ 1:out  0:in
    PUP0 = 0x00;                       //io   1:enable  0:disable
    PDP0 = 0x00;                       //io   1:enable  0:disable
    P0ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP1 = 0x00;                       //ioλ
    OEP1 = 0xFF;                       //ioڷ 1:out  0:in
    PUP1 = 0x00;                       //io   1:enable  0:disable
    PDP1 = 0x00;                       //io   1:enable  0:disable
    P1ADCR = 0x00;                     //ioѡ  1:ģ  0:ͨio

    IOP2 = 0x00;                       //ioλ
    OEP2 = 0x03;                       //ioڷ 1:out  0:in
    PUP2 = 0x00;                       //io   1:enable  0:disable
    PDP2 = 0x00;                       //io   1:enable  0:disablea
}
/************************************************
;  *    @            : TIMER0_PWM_Init
;  *    @˵              : ʱ0,PWMʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_PWM_Init(void)
{
    T0CR = DEF_SET_BIT0 | DEF_SET_BIT1;//CPU,8Ƶ
    T0CNT = 100-1;
    T0LOAD = 100-1;
    T0DATA = 25;
    PWM0CR0 = DEF_SET_BIT0;            //PWM0ֹFPWM
    PWM0CR1 = 0x00;
    PWM0EN = 1;                        //ʹPWM
    T0EN = 1;
}
/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_PWM_Init();
    GIE = 1;
}
/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {

    }
}
/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;
   
__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
