/******************************************************************************
;  *       @ͺ                 : MC30P6310
;  *       @             : 2023.01.31
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *             T0 1S P12DתһΣ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    __asm 
    movai 0x40 
    movra FSR
    movai 48 
    movra 0x07 
    decr FSR
    clrr INDF
    djzr 0x07 
    goto $ -3;
    clrr 0x07 
    __endasm;
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    P1 = 0x00;               //IOλ
    DDR1 = 0x00;             //IOڷ 1:input 0:output
    PUCON = 0xFF;            //IO 0:Effective 1:invalid
    PDCON = 0xFF;            //IO 0:Effective 1:invalid
    P1ADCR = 0x00;           //IOֹ 0:Effective 1:invalid
    ODCON = 0x00;            //0:  1:©
}

/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = 0x07;             //256Ƶ 
    T0CNT = 256 - 128;       //1S
    TM0CR = 0x80;            //ⲿƵϵͳʱ
    T0IF = 0;
    T0IE = 1;
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
   {
        GIE = 0;        //رж
        Nop();
        Nop();
        Stop();         //
        Nop();
        Nop();
        GIE = 1;        //ж
        P12D = !P12D;
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _STATUS
    movra _statusbuf
    __endasm;

    if ((T0IF) && (T0IE))
    {
        T0IF = 0;
        T0CNT = 256 - 128;
    }

    __asm 
    swapar _statusbuf
    movra _STATUS
    swapr _abuf
    swapar _abuf
    __endasm;
}


/**************************** end of file *********************************************/