/******************************************************************************
;  *       @ͺ                 : MC30P6310
;  *       @             : 2023.01.19
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      TIMER1 PWM  80K
;  *                    P12D  T=80K, D=20% 
;  *                    P11D  T=80K, D=40% 
;  *                    P10D  T=80K, D=60% 
;  *                    P15D  T=80K, D=80% 
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    __asm 
    movai 0x40 
    movra FSR
    movai 48 
    movra 0x07 
    decr FSR
    clrr INDF
    djzr 0x07 
    goto $ -3;
    clrr 0x07 
    __endasm;
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    P1 = 0x00;               //IOλ
    DDR1 = 0x00;             //IOڷ 1:input 0:output
    PUCON = 0xFF;            //IO 0:Effective 1:invalid
    PDCON = 0xFF;            //IO 0:Effective 1:invalid
    P1ADCR = 0x00;           //IOֹ 0:Effective 1:invalid 
    ODCON = 0x00;            //0:  1:©
}

/************************************************
;  *    @            : TIMER1_PWM_Init
;  *    @˵              : PWM
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_PWM_Init(void)
{
    T1CR = 0xC0;             //ʱΪCPUʱ    ʱ64Ƶ  1ms
    T1LOAD = 100-1; 
    T1CNT = 100-1;
    PWM1CR0 = 0x63;
    PWM1CR1 = 0x03;          //ȡ
    T1DATA = 20;
    T1DATB = 40;
    T1DATC = 60;
    T1DATD = 80;
    T1IE = 1;
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER1_PWM_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {

    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _STATUS
    movra _statusbuf
    __endasm;


    if ((T1IF) && (T1IE))
    {
        T1IF = 0;
    }

    __asm 
    swapar _statusbuf
    movra _STATUS
    swapr _abuf
    swapar _abuf
    __endasm;
}


/**************************** end of file *********************************************/