/******************************************************************************
;  *       @ͺ                 : MC30P6310
;  *       @             : 2023.01.19
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *             T1 5s־һ   P10Dжϻ
;  *             P13Dߵƽ˳ߵ͵ƽ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    __asm 
    movai 0x40 
    movra FSR
    movai 48 
    movra 0x07 
    decr FSR
    clrr INDF
    djzr 0x07 
    goto $ -3;
    clrr 0x07 
    __endasm;
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    P1 = 0x00;               //IOλ
    DDR1 = 0x00;             //IOڷ 1:input 0:output
    PUCON = 0xFF;            //IO 0:Effective 1:invalid
    PDCON = 0xFF;            //IO 0:Effective 1:invalid
    P1ADCR = 0x00;           //IOֹ 0:Effective 1:invalid 
    ODCON = 0x00;            //0:  1:©
}

/************************************************
;  *    @            : TIMER1_INT_Init
;  *    @˵              : TIMER1ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = 0x86;        //FCPU 64Ƶ
    T1LOAD = 125-1;     //1ms
    T1CNT = 125-1;
    T1IE = 1;
}

/************************************************
;  *    @            : KBIE_Init
;  *    @˵              : жϳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void KBIE_Init(void)
{
    DDR1 = 0x01;             //in
    PUCON = 0xFE;            //
    P1KBCR = 0x01;           //P10Dж
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER1_INT_Init();
    KBIE_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
       if(Flag_Timer1_5000ms)
       {
            Flag_Timer1_5000ms = RESET;
            GIE = 0;
            KBIF= 0;
            KBIE = 1;
            P13D = 1;
            Nop();
            Nop();
            Stop();
            Nop();
            Nop();
            KBIE = 0;
            KBIF = 0;
            GIE = 1;
            P13D = 0;
       }
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _STATUS
    movra _statusbuf
    __endasm;

    if ((T1IF) && (T1IE))    //1ms
    {
        T1IF = 0;
        timer1_count1++;
        if(timer1_count1 >= 5000)
        {
            timer1_count1 = 0;
            Flag_Timer1_5000ms = SET;
        }
    }

    __asm 
    swapar _statusbuf
    movra _STATUS
    swapr _abuf
    swapar _abuf
    __endasm;
}


/**************************** end of file *********************************************/