/******************************************************************************
;  *       @ͺ                 : MS32F7073
;  *       @             : 2023.03.07
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      ADC
;  *               ϵȴADȶУ׼
;  *               ADCʱΪ HIRC32Ƶ1M12λH8L4ڲ2V15ADCLK
;  *               P21ɼѹÿ1SӡһADֵ0xA5ͷ  0x5Aβ
;  *               ע TX0(P11) RX0(P10) 4800
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : delay
;  *    @˵            : ȷʱ
;  *    @        : ʱʱ
;  *    @ز        :
;  ***********************************************/
void delay(uint16_t num)
{
    for (i = 0; i < num; i++)     //FCPU 4M
    {
        Nop();
    }
}

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in 
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable
    
    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in 
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable
    
    IOP2 = 0x00;             //ioλ
    OEP2 = 0xFF;             //ioڷ 1:out  0:in 
    PUP2 = 0x00;             //io   1:enable  0:disable
    PDP2 = 0x00;             //io   1:enable  0:disable

    ADIOS0 = 0x00;           //ioѡ  1:ģ  0:ͨio
    ADIOS1 = 0x00;           //ioѡ  1:ģ  0:ͨio
}

/************************************************
;  *    @            : ADC_Power_On_Stability
;  *    @˵              : ADCϵȶ
;  *    @          :
;  *    @ز          : ֵ
;  ***********************************************/
u8 ADC_Power_On_Stability(void)
{
    uint8_t cnt;
    ADCR0 = 0xFF;            //ʹADCڲVDDVDD/4ͨ
    ADCR1 = 0x23;            //12λH8L432Ƶ15ADCLK
    ADEOC = 0;
    while (!ADEOC);
    cnt = 0;
    while (!(((ADRH >> 2) == 0x10) || ((ADRH >> 2) == 0x0F)))
    {
        ADEOC = 0;
        while (!ADEOC);
        cnt++;
        if (cnt >= 200)
            return;          //δͨϵȶ
    }
}

/************************************************
;  *    @            : ADC_Zero_ADJ
;  *    @˵              : У׼
;  *    @          :
;  *    @ز          :
;  ***********************************************/
uint8_t ADC_Zero_ADJ(void)
{
    ADCR0 = 0xE3;                 //ʹADCڲ2VGNDͨ
    ADCR1 = 0x23;                 //12λH8L432Ƶ15ADCLK
    OSADJCR |= DEF_SET_BIT7;      //ʹУ׼޵
    ADEOC = 0;
    while (!ADEOC);
    if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) //ǷΪ0
    {
        OSADJTD = 1;                         //޵
        OSADJCR |= 0x1F;
        ADEOC = 0;
        while (!ADEOC);
        if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) //ǷΪ0
        {
            ADEN = 0;
            return 0;
        }
        else
        {
            while (1)
            {
                if (OSADJCR & 0x1F)
                {
                    OSADJCR--;
                    ADEOC = 0;
                    while (!ADEOC);
                    if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) //ǷΪ0
                    {
                        ADEN = 0;
                        return 0;
                    }
                }
                else
                {
                    ADEN = 0;
                    return 1;
                }
            }
        }
    }
    else
    {
        while (1)
        {
            if ((OSADJCR & 0x1F) == 0x1F)
            {
                ADEN = 0;
                return 1;
            }
            else
            {
                OSADJCR++;
                ADEOC = 0;
                while (!ADEOC);
                if ((ADRH == 0) && ((ADRL & 0x0F) == 0)) //ǷΪ0
                {
                    ADEN = 0;
                    return 0;
                }
            }
        }
    }
}

/************************************************
;  *    @            : ADC_Init
;  *    @˵              : ADCʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void ADC_Init(void)
{
    OEP2 &= DEF_CLR_BIT1;              //P21D
    ADIOS0 |= DEF_SET_BIT0;            //ʹģ⹦
    ADCR0 = 0xE3;                      //ʹADCڲ2V
    ADCR1 = 0x23;                      //12λH8L432Ƶ15ADCLK
}

/************************************************
;  *    @            : ADC_Get_Value_Average
;  *    @˵              : ת
;  *    @          : ͨ
;  *    @ز          : ADCֵ
;  *    ռڴϴ        
;  ***********************************************/
uint ADC_Get_Value_Average(u8 CHX)
{
    g_temp_value = 0;
    g_channel = 0;
    g_tmpbuff = 0;
    g_adcmax = 0;
    g_adcmin = 0xFFFF;
    ADCR0 = (ADCR0 & 0x0F) | (CHX << 4);         // ADC ʹ  ADתͨ  ͨ  CHX
    delay(300);                                  //лͨʱ200uS  Լ1ms
    for (g_channel = 0; g_channel < 20; g_channel ++)
    {
        ADEOC = 0;
        while (!ADEOC);                          //ȴת
        g_temp_value = ADRH;
        g_temp_value = g_temp_value << 4 | (ADRL & 0x0F);
        if (g_channel < 2)
            continue;                            //ǰβ
        if (g_temp_value > g_adcmax)
            g_adcmax = g_temp_value;             //
        if (g_temp_value < g_adcmin)
            g_adcmin = g_temp_value;             //С
        g_tmpbuff += g_temp_value;
    }
    g_tmpbuff -= g_adcmax;                       //ȥһ
    g_tmpbuff -= g_adcmin;                       //ȥһС
    g_temp_value = (g_tmpbuff >> 4);             //16ȡƽֵ
    return g_temp_value;
}

/************************************************
;  *    @            : UART_Init
;  *    @˵              :   IO
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void UART_Init(void)
{
    IOP1 |= 0x02;            //IOĬϸ
    P10OE = 0;               //P10in
    P10PU = 1;               //P10up

    T2CR = 0x80;             //FCPU   Ƶ 
    T2LOADH = 0x00;
    T2LOADL = 51;            //Baud=FT2/(16*(T2LOAD+1))  4800

    SCON = 0x54;             //ʽ1
    UARTIE = 1;
}

/************************************************
;  *    @            : UART_Send_Byte
;  *    @˵              : 
;  *    @          : 
;  *    @ز          :
;  ***********************************************/
void UART_Send_Byte(u8 dat)
{
    REN = 0;            //ֹ
    UARTIE = 0;         //رжʹ
    SBUF = dat;         //дݵUARTݼĴ
    while (!TI);        //ȴǰݷ
    TI = 0;
    REN = 1;
    UARTIE = 1;
}

/************************************************
;  *    @            : TIMER1_INT_Init
;  *    @˵              : ʱ1ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = DEF_SET_BIT0 | DEF_SET_BIT2;     //ʱģʽ,CPU,32Ƶ
    T1CNTH = 0;
    T1CNTL = 125 - 1;
    T1LOADH = 0;                            //1ms
    T1LOADL = 125 - 1;
    T1EN = 1;
    T1IE = 1;
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER1_INT_Init();
    ADC_Power_On_Stability();
    while (ADC_Zero_ADJ());            //demoʾ,У׼ʧһֱУ׼ûѡǷУ׼
    ADC_Init();
    UART_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if(FLAG_TIMER1_1000MS)
        {
            FLAG_TIMER1_1000MS = RESET;
            g_adc_value0_temp = ADC_Get_Value_Average(0);
            UART_Send_Byte(0xA5);
            UART_TX_Num = g_adc_value0_temp >> 8;
            UART_Send_Byte(UART_TX_Num);
            UART_TX_Num = g_adc_value0_temp & 0xFF;
            UART_Send_Byte(UART_TX_Num);
            UART_Send_Byte(0x5A);
        }
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

    if (T1IF & T1IE)
    {
        T1IF = 0;
        timer1_cnt1++;
        if (timer1_cnt1 >= 1000)        //1s
        {
            timer1_cnt1 = 0;
            FLAG_TIMER1_1000MS = SET;
        }
    }

__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/

