/******************************************************************************
;  *       @ͺ                 : MC32F7073
;  *       @             : 2023.03.09
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                   ʱ-Ƶ ÿ10msһ
;  *                   T0   P10 100uSת
;  *                   T1   P11 10mSת ޸HIRCCAL ΢CPUʱ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in 
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable
    
    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in 
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable
    
    IOP2 = 0x00;             //ioλ
    OEP2 = 0xFF;             //ioڷ 1:out  0:in 
    PUP2 = 0x00;             //io   1:enable  0:disable
    PDP2 = 0x00;             //io   1:enable  0:disable

    ADIOS0 = 0x00;           //ioѡ  1:ģ  0:ͨio
    ADIOS1 = 0x00;           //ioѡ  1:ģ  0:ͨio
}

/************************************************
;  *    @            : TIMER0_INT_Init
;  *    @˵              : ʱ0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_INT_Init(void)
{
    T0CR = DEF_SET_BIT0 | DEF_SET_BIT1;     //ʱģʽ,CPU,8Ƶ
    T0CNT = 100-1;
    T0LOAD = 100-1;                         //100us
    T0EN = 1;
    T0IE = 1;
}

/************************************************
;  *    @            : TIMER1_INT_Init
;  *    @˵              : ʱ1ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = DEF_SET_BIT0 | DEF_SET_BIT2;     //ʱģʽ,CPU,32Ƶ
    T1CNTH = 0;
    T1CNTL = 250 - 1;
    T1LOADH = 0;                            //1ms
    T1LOADL = 250 - 1;
    T1EN = 1;
    T1IE = 1;
}

/************************************************
;  *    @            : HIRC_Adjust
;  *    @˵              : Ƶ΢
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void HIRC_Adjust(void)
{
    if (FLAG_PFRCR_ADD_DEC)
    {
        if (g_hirc_temp < g_hirc_back)
        {
            g_hirc_temp ++;
        }else FLAG_PFRCR_ADD_DEC = 0;  //ӵg_hirc_back   ʼݼ
    }
    else
    {
        if(g_hirc_temp > 0)
        {
            g_hirc_temp --;
        }else FLAG_PFRCR_ADD_DEC = 1;  //0  ʼ
    }
    HIRCCAL = g_hirc_temp;             //޸΢Ĵ
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_INT_Init();
    TIMER1_INT_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    g_hirc_back = HIRCCAL;             //Ƶ΢У׼λ
    g_hirc_temp = g_hirc_back;
    while (1)
    {
        if (FLAG_TIMER1_10ms)          //10mS޸һ
        {
            FLAG_TIMER1_10ms = RESET;
            HIRC_Adjust();             //Ƶ΢
        }
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

    if ((T0IF) && (T0IE))
    {
        P10D = !P10D;
        T0IF = 0;
    }
    if ((T1IF) && (T1IE))
    {
        timer1_cnt1++;
        if (timer1_cnt1 >= 10)
        {
            timer1_cnt1 = 0;
            FLAG_TIMER1_10ms = SET;
            P11D = !P11D;
        }
        T1IF = 0;
    }

__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
