/******************************************************************************
;  *       @ͺ                 : MS32F7073
;  *       @             : 2023.03.07
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                  IIC  100Kbps
;  *                24C02дݣٶ(P01-SDA P02-SCL)
;  *                UARTӡݣ0xA5ͷ 0x5Aβ
;  *                עڣTX0(P11) RX0(P10) 4800
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : Delay
;  *    @˵            : ȷʱ
;  *    @        : ʱʱ
;  *    @ز        :
;  ***********************************************/
void Delay(uint16_t num)
{
    for (i = 0; i < num; i++)     //FCPU 4M
    {
        Nop();
    }
}

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xF9;             //ioڷ 1:out  0:in 
    PUP0 = 0x03;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable
    
    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in 
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable
    
    IOP2 = 0x00;             //ioλ
    OEP2 = 0xFF;             //ioڷ 1:out  0:in 
    PUP2 = 0x00;             //io   1:enable  0:disable
    PDP2 = 0x00;             //io   1:enable  0:disable

    ADIOS0 = 0x00;           //ioѡ  1:ģ  0:ͨio
    ADIOS1 = 0x00;           //ioѡ  1:ģ  0:ͨio
}

/************************************************
;  *    @            : IIC_Init
;  *    @˵              : IICʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IIC_Init(void)
{
    IICCR = 0x01;            //100Kbps ж
    IICIF = 0;
    IICIE = 1;               //IICжʹ
    
    IICEN = 1;               //ʹIIC
}

/************************************************
;  *    @            : UART_Init
;  *    @˵              :   IO
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void UART_Init(void)
{
    IOP1 |= 0x02;            //IOĬϸ
    P10OE = 0;               //P10in
    P10PU = 1;               //P10up

    T2CR = 0x80;             //FCPU   Ƶ 
    T2LOADH = 0x00;
    T2LOADL = 51;            //Baud=FT2/(16*(T2LOAD+1))  4800

    SCON = 0x54;             //ʽ1
    UARTIE = 1;
}

/************************************************
;  *    @            : IIC_Start
;  *    @˵              : IICʼź
;  *    @          : ӻַ /дָ
;  *    @ز          :
;  ***********************************************/
void IIC_Start(u8 R_Slave_addr,u8 CMD)
{
    IICSTR = 1;              //ʼź
    while(FLAG_IIC_DONE == RESET);     //˳ж
    FLAG_IIC_DONE = RESET;
    if(CMD)                  //IIC
    {
        IICDR = R_Slave_addr + 1;
    }
    else                     //IICд
    {
        IICDR = R_Slave_addr;
    }
    IICWR = 1;
    while(FLAG_IIC_DONE == RESET);
    FLAG_IIC_DONE = RESET;
}

/************************************************
;  *    @            : AT24C02_Write_Len_Byte
;  *    @˵              : д
;  *    @          : ֵַ  
;  *    @ز          :
;  ***********************************************/
void AT24C02_Write_Len_Byte(u8 addr,u8 *data,u8 len)
{
    while(len)
    {
        AT24C02_Write_Byte(addr++,*data++);
        len--;
        Delay(2000);        //ʱԼ6.6ms
    }
}

/************************************************
;  *    @            : AT24C02_Write_Byte
;  *    @˵              : д
;  *    @          :  
;  *    @ز          :
;  ***********************************************/
void AT24C02_Write_Byte(u8 addr,u8 data)
{
    IIC_Start(EE_24C02_ADDR,IIC_WRITE_CMD);
    IIC_Write_Byte(addr);
    IIC_Write_Byte(data);
    IIC_Stop();
}

/************************************************
;  *    @            : IIC_Write_Byte
;  *    @˵              : дһ
;  *    @          : 
;  *    @ز          :
;  ***********************************************/
void IIC_Write_Byte(u8 data)
{
    if(RACKF == 0)
    {
        IICDR = data;
        IICWR = 1;
        while(FLAG_IIC_DONE == RESET);
        FLAG_IIC_DONE = RESET;
    }
}

/************************************************
;  *    @            : AT24C02_Read_Len_Byte
;  *    @˵              : 
;  *    @          : ַ  
;  *    @ز          :
;  ***********************************************/
void AT24C02_Read_Len_Byte(u8 addr,u8 *data,u8 len)
{
    UART_Send_Byte(0xA5);
    while(len)
    {
        *data = AT24C02_Read_Byte(addr++);
        UART_Send_Byte(*data);
        data++;
        len--;
    }
    UART_Send_Byte(0x5A);
}

/************************************************
;  *    @            : IIC_Read_Byte
;  *    @˵              : һ
;  *    @          : ֵַ
;  *    @ز          : 
;  ***********************************************/
u8 AT24C02_Read_Byte(u8 addr)
{
    IIC_Start(EE_24C02_ADDR,IIC_WRITE_CMD);
    IIC_Write_Byte(addr);
    IIC_Start(EE_24C02_ADDR,IIC_READ_CMD);
    num_value = IIC_Read_Byte();  
    IIC_Stop();
    return num_value;
}

/************************************************
;  *    @            : IIC_Read_Byte
;  *    @˵              : һ
;  *    @          :
;  *    @ز          : 
;  ***********************************************/
u8 IIC_Read_Byte(void)
{
    if(RACKF == 0)
    {
        IICRD = 1;
        while(FLAG_IIC_DONE == RESET);
        FLAG_IIC_DONE = RESET;
        temp = IICDR;
        TACKS = 1;        
        IICACK = 1;
        while(FLAG_IIC_DONE == RESET);
        FLAG_IIC_DONE = RESET;
        return temp;
    }
}

/************************************************
;  *    @            : IIC_Stop
;  *    @˵              : IICֹͣź
;  *    @          : 
;  *    @ز          :
;  ***********************************************/
void IIC_Stop(void)
{
    IICSTP = 1;              //STOPź
    while(FLAG_IIC_DONE == RESET);
    FLAG_IIC_DONE = RESET;
}

/************************************************
;  *    @            : UART_Send_Byte
;  *    @˵              : 
;  *    @          : 
;  *    @ز          :
;  ***********************************************/
void UART_Send_Byte(u8 dat)
{
    REN = 0;            //ֹ
    UARTIE = 0;         //رжʹ
    SBUF = dat;         //дݵUARTݼĴ
    while (!TI);        //ȴǰݷ
    TI = 0;
    REN = 1;            //ʹܽ Ҫݿ
    UARTIE = 1;         //ҪUARTжϿ
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    IIC_Init();
    UART_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    AT24C02_Write_Len_Byte(0,IIC_test_buff_data,IIC_DATA_LEN);
    Delay(500);         //ʱԼ1.7ms
    AT24C02_Read_Len_Byte(0,IIC_test_buff,IIC_DATA_LEN);
    while(1)
    {
    }
}

void int_isr(void)__interrupt
{
__asm
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

    if(IICIF)
    {
        IICIF  = 0;
        FLAG_IIC_DONE = SET;
    }

__asm
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}
