/******************************************************************************
;  *       @ͺ                   : MC32F7073
;  *       @               : 2023.03.10
;  *       @˾/              : ΢-FAE
;  *       @΢             : http://www.sinomcu.com/
;  *       @Ȩ                   : 2023 ΢繫˾Ȩ.
;  *----------------------  ---------------------------------
;  *                   ʱʹȫֱ                       
******************************************************************************/
#ifndef USER
#define USER
#include <mc32-common.h>
#include "MC32F7073.h"

/*****************************************************************
;       Function : Define variables
;*****************************************************************/
#define u8 unsigned char
#define u16 unsigned int
#define u32 unsigned long int
#define uint8_t  unsigned char
#define uint16_t unsigned int
#define uint32_t unsigned long int

#define DEF_SET_BIT0                0x01
#define DEF_SET_BIT1                0x02
#define DEF_SET_BIT2                0x04
#define DEF_SET_BIT3                0x08
#define DEF_SET_BIT4                0x10
#define DEF_SET_BIT5                0x20
#define DEF_SET_BIT6                0x40
#define DEF_SET_BIT7                0x80

#define DEF_CLR_BIT0                0xFE
#define DEF_CLR_BIT1                0xFD
#define DEF_CLR_BIT2                0xFB
#define DEF_CLR_BIT3                0xF7
#define DEF_CLR_BIT4                0xEF
#define DEF_CLR_BIT5                0xDF
#define DEF_CLR_BIT6                0xBF
#define DEF_CLR_BIT7                0x7F

#define SET                         1
#define RESET                       0
#define PASS                        1
#define FAIL                        0

#define IIC_WRITE_CMD               0
#define IIC_READ_CMD                1
#define EE_24C02_ADDR               0xA0
#define IIC_DATA_LEN                10

//===============Field Protection Variables===============
u8 abuf;
u8 statusbuf;

//===============Global Variable===============
u8 temp;
u8 num_value;
const u8 IIC_test_buff_data[IIC_DATA_LEN]={10,11,12,13,14,15,16,17,18,19};
u8 IIC_test_buff[IIC_DATA_LEN];
u16 i;

//===============Global Function===============
void CLR_RAM(void);
void IO_Init(void);
void INT_Init(void);
void IIC_Init(void);
void IIC_Start(u8 R_Slave_addr,u8 CMD);
void IIC_Stop(void);
void IIC_Write_Byte(u8 data);
u8 IIC_Read_Byte(void);
void AT24C02_Write_Byte(u8 addr,u8 data);
u8 AT24C02_Read_Byte(u8 addr);
void AT24C02_Write_Len_Byte(u8 addr,u8 *data,u8 len);
void AT24C02_Read_Len_Byte(u8 addr,u8 *data,u8 len);
void Delay(u16 num);
u8 Data_Comparison(u8 *data1,u8 *data2,u8 len);
void UART_Init();
void UART_Send_Byte(u8 dat);
void Sys_Init(void);

//============Define  Flag=================
typedef union {
    unsigned char byte;
    struct
    {
        u8 bit0 : 1;
        u8 bit1 : 1;
        u8 bit2 : 1;
        u8 bit3 : 1;
        u8 bit4 : 1;
        u8 bit5 : 1;
        u8 bit6 : 1;
        u8 bit7 : 1;
    } bits;
}bit_flag;
volatile bit_flag flag1;

#define     FLAG_IIC_DONE          flag1.bits.bit0  

#endif

/**************************** end of file *********************************************/

