/******************************************************************************
;  *       @ͺ                 : MS32F7073
;  *       @             : 2023.03.06
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      ⲿж
                    INT0 P00ش P10ת
                    INT1 P20ش P11ת
                    INT2 P21½ش P12ת
                    INT3 P03½ش P13ת
                    עԿʹ[PDT0] [PCK0]
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in 
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable
    
    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in 
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable
    
    IOP2 = 0x00;             //ioλ
    OEP2 = 0xFF;             //ioڷ 1:out  0:in 
    PUP2 = 0x00;             //io   1:enable  0:disable
    PDP2 = 0x00;             //io   1:enable  0:disable

    ADIOS0 = 0x00;           //ioѡ  1:ģ  0:ͨio
    ADIOS1 = 0x00;           //ioѡ  1:ģ  0:ͨio
}

/************************************************
;  *    @            : INT_Init
;  *    @˵              : ⲿжϳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void INT_Init(void)
{
    OEP0 = 0xF6;             //P00 P03 in
    PUP0 = 0x08;             //P03 up
    PDP0 = 0x01;             //P00 down

    OEP2 = 0xFC;             //P20 P21 in
    PUP2 = 0x02;             //P21 up
    PDP2 = 0x01;             //P20 down

    MCR &= 0xF0;             //INT0/1 ش  INT2/3 ֻ½ش
    INT0IE = 1;
    INT1IE = 1;
    INT2IE = 1;
    INT3IE = 1;
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE  =  0;
    CLR_RAM();
    IO_Init();
    INT_Init();
    GIE   =  1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while(1)
    {    

    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void)__interrupt
{
__asm
    movra   _abuf
    swapar  _PFLAG
    movra   _statusbuf
__endasm;
    if ((INT0IF) && (INT0IE)) 
    {
        P10D = !P10D;
        INT0IF = 0;
    }
    if ((INT1IF) && (INT1IE)) 
    {
        P11D = !P11D;
        INT1IF = 0;
    }
    if ((INT2IF) && (INT2IE)) 
    {
        P12D = !P12D;
        INT2IF = 0;
    }
    if ((INT3IF) && (INT3IE)) 
    {
        P13D = !P13D;
        INT3IF = 0;
    }
    
__asm
    swapar  _statusbuf
    movra   _PFLAG
    swapr   _abuf
    swapar  _abuf
__endasm;
}

/**************************** end of file *********************************************/