/******************************************************************************
;  *       @ͺ                 : MC32F7073
;  *       @             : 2023.03.09
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                PWM0  P04 Duty:20% F=5K
;  *                FPWM0 P03 DT=16us
;  *                PWM1  P14 Duty:40% F=10K
;  *                PWM3A P20 Duty:60% F=20K
;  *                PWM3B P10 Duty:70%
;  *                PWM3C P11 Duty:80%
;  *             עԿʹ[PCK0] [PDT0]
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in P00D 
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable
    
    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in P00D 
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable
    
    IOP2 = 0x00;             //ioλ
    OEP2 = 0xFF;             //ioڷ 1:out  0:in P00D 
    PUP2 = 0x00;             //io   1:enable  0:disable
    PDP2 = 0x00;             //io   1:enable  0:disable

    ADIOS0 = 0x00;           //ioѡ  1:ģ  0:ͨio
    ADIOS1 = 0x00;           //ioѡ  1:ģ  0:ͨio
}

/************************************************
;  *    @            : TIMER0_PWM_Init
;  *    @˵              : PWM0ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER0_PWM_Init(void)
{
    T0DATA = 20;
    T0CNT = 100-1;
    T0LOAD = 100-1;               //200us
    T0CR = 0x44;                  //ʱģʽ ʹPWM CPU   16Ƶ
    PWM0CR0 = 0x01;               //ȡ FPWM
    PWM0CR1 = 0x07;               //8ʱ
    T0EN = 1;
}

/************************************************
;  *    @            : TIMER1_PWM_Init
;  *    @˵              : PWM1ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER1_PWM_Init(void)
{
    T1DATAH = 0;
    T1DATAL = 40;
    T1CNTH = 0;
    T1CNTL = 100-1;
    T1LOADH = 0;
    T1LOADL = 100-1;              //100us
    T1CR = 0x43;                  //ʱģʽ ʹPWM CPU 8Ƶ
    T1EN = 1;
}

/************************************************
;  *    @            : TIMER3_PWM_Init
;  *    @˵              : ʱ3ʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void TIMER3_PWM_Init(void)
{
    T3DATA = 60;
    T3DATB = 70;
    T3DATC = 80;
    T3CNT = 100 - 1;
    T3LOAD = 100 - 1;
    T3CR = 0x02;                       //CPU,4Ƶ
    PWM3CR = 0x15;                     //PWMʹ ȡ
    T3EN = 1;
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER0_PWM_Init();
    TIMER1_PWM_Init();
    TIMER3_PWM_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {

    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/

