/******************************************************************************
;  *       @ͺ                 : MS32F7073
;  *       @             : 2023.03.07
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2023 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                  շ  4800
;  *            ڣTX0(P11) RX0(P10)
;  *            MCUյݣMCU͸
;  *            ʱ跢У0xA5  0x5Aβ
******************************************************************************/

#include "user.h"

/************************************************
;  *    @          : CLR_RAM
;  *    @˵            : RAM
;  *    @        :
;  *    @ز        :
;  ***********************************************/
void CLR_RAM(void)
{
    for(FSR0 = 0;FSR0 < 0xFF;FSR0++) 
    {
        INDF0 = 0x00;
    }
    FSR0 = 0xFF;
    INDF0 = 0x00;
    for(FSR1 = 0;FSR1 < 0x7F;FSR1++) 
    {
        INDF1 = 0x00;
    }
    FSR1 = 0x7F;
    INDF1 = 0x00; 
}

/************************************************
;  *    @            : IO_Init
;  *    @˵              : IOʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable
    
    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable
    
    IOP2 = 0x00;             //ioλ
    OEP2 = 0xFF;             //ioڷ 1:out  0:in
    PUP2 = 0x00;             //io   1:enable  0:disable
    PDP2 = 0x00;             //io   1:enable  0:disable

    ADIOS0 = 0x00;           //ioѡ  1:ģ  0:ͨio
    ADIOS1 = 0x00;           //ioѡ  1:ģ  0:ͨio
}

/************************************************
;  *    @            : UART_Init
;  *    @˵              :   IO
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void UART_Init(void)
{
    IOP1 |= 0x02;            //IOĬϸ
    P10OE = 0;               //P10in
    P10PU = 1;               //P10up

    T2CR = 0x80;             //FCPU   Ƶ 
    T2LOADH = 0x00;
    T2LOADL = 51;            //Baud=FT2/(16*(T2LOAD+1))  4800

    SCON = 0x54;             //ʽ1
    UARTIE = 1;
}

/************************************************
;  *    @            : UART_Send_Byte
;  *    @˵              : 
;  *    @          : 
;  *    @ز          :
;  ***********************************************/
void UART_Send_Byte(u8 dat)
{
    REN = 0;            //ֹ
    UARTIE = 0;         //رжʹ
    SBUF = dat;         //дݵUARTݼĴ
    while (!TI);        //ȴǰݷ
    TI = 0;
    REN = 1;            //ʹܽ
    UARTIE = 1;
}

/************************************************
;  *    @            : Sys_Init
;  *    @˵              : ϵͳʼ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    UART_Init();
    GIE = 1;
}

/************************************************
;  *    @            : main
;  *    @˵              : 
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if (FLAG_UART_RX_END == SET)
        {
            len = UART_RX_len;         //õ˴νյݳ
            for (t = 0; t < len; t++)
            {
                //дݵUARTݼĴ
                UART_Send_Byte(UART_RX_buff[t]);
            }
            FLAG_UART_RX_END = RESET;
            UART_RX_len = 0;
            FLAG_UART_RX_STA = RESET;
        }
    }
}

/************************************************
;  *    @            : interrupt
;  *    @˵              : жϺ
;  *    @          :
;  *    @ز          :
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm 
    movra _abuf
    swapar _PFLAG
    movra _statusbuf
__endasm;

    if (UARTIF)
    {
        UARTIF = 0;
        if (RI) //
        {
            RI = 0;
            if (FLAG_UART_RX_END == RESET)
            {
                if (FLAG_UART_RX_STA == RESET)
                {
                    if (SBUF == 0xA5)          //0xA5ͷ
                    {
                        FLAG_UART_RX_STA = SET;
                    }
                }
                else
                {
                    if (SBUF == 0x5A)          //0x5Aβ
                    {
                        FLAG_UART_RX_END = SET;
                    }
                    else
                    {
                        UART_RX_buff[UART_RX_len] = SBUF;
                        UART_RX_len++;
                    }
                }
            }
        }
    }

__asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
__endasm;
}

/**************************** end of file *********************************************/
