/******************************************************************************
;  *       @ͺ                 : MC32T7051
;  *       @             : 2025.3.25
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2025 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                      ʱ
;  *               T1(ʱڲ32K)1S       P11ת
******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
   	for(FSR0=0; FSR0<0x7F; FSR0++)
   	{
   	   	INDF0 = 0x00;
   	}
    FSR0 = 0x7F;
   	INDF0 =0x00;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable

    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in   
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable

    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    PMOD = 0x00;             //P13D
}

/************************************************
;  *    @Function Name       : TIMER1_INT_Init
;  *    @Description         : T1ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = DEF_SET_BIT0 | DEF_SET_BIT1 | DEF_SET_BIT2 | DEF_SET_BIT4;//ڲƵ,128Ƶ
    T1LOAD = 250-1;
    T1CNT = 250-1;
    T1EN = 1;
    T1IE = 1;
}

/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    TIMER1_INT_Init();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    HFEN=0;
    LFEN=1;                            //رոƵ,ڲƵʼչ
    while (1)
    {
        Nop();
        Nop();
        Stop();
        Nop();
        Nop();
        P11D =! P11D;
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _PFLAG
    movra _statusbuf
    __endasm;
    //=======T1========================
    if (T1IF & T1IE)
    {
        T1IF = 0;
    }
    __asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
    __endasm;
}

/**************************** end of file *********************************************/

