/******************************************************************************
;  *       @ͺ                 : MC32T7051
;  *       @             : 2025.3.25
;  *       @˾/            : ΢-FAE
;  *       @΢           : http://www.sinomcu.com/
;  *       @Ȩ                 : 2025 ΢繫˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *                   жϻ
;  *                5sģʽP11ߵƽ
;  *                P10жϻѣP11͵ƽ 
******************************************************************************/
#include "user.h"

/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : RAM
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void CLR_RAM(void)
{
   	for(FSR0=0; FSR0<0x7F; FSR0++)
   	{
   	   	INDF0 = 0x00;
   	}
    FSR0 = 0x7F;
   	INDF0 =0x00;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : IOʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
    IOP0 = 0x00;             //ioλ
    OEP0 = 0xFF;             //ioڷ 1:out  0:in
    PUP0 = 0x00;             //io   1:enable  0:disable
    PDP0 = 0x00;             //io   1:enable  0:disable

    IOP1 = 0x00;             //ioλ
    OEP1 = 0xFF;             //ioڷ 1:out  0:in   
    PUP1 = 0x00;             //io   1:enable  0:disable
    PDP1 = 0x00;             //io   1:enable  0:disable

    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    P0ADCR = 0x00;           //ioֹ 1:disable  0:enable
    PMOD = 0x00;             //P13D
}

/************************************************
;  *    @Function Name       : TIMER1_INT_Init
;  *    @Description         : T1ʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_INT_Init(void)
{
    T1CR = 0x85;             //ʱΪCPUʱ    ʱ32Ƶ  1ms
    T1LOAD = 250-1;
    T1CNT = 250-1;
    T1IE = 1;
}

/************************************************
;  *    @Function Name       : KBIE_Init
;  *    @Description         : жϳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void KBIE_Init(void)
{
    OEP1 = 0x3E;                       //P10 IN
    PUP1 = 0x01;                       //
    P1KBCR = 0x01;                     //P10ж                    
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
    GIE = 0;
    CLR_RAM();
    IO_Init();
    KBIE_Init();
    TIMER1_INT_Init();
    GIE = 1;
}

/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void main(void)
{
    Sys_Init();
    while (1)
    {
        if (FLAG_TIMER1_5000MS)
        {
            FLAG_TIMER1_5000MS = 0;
            GIE = 0;
            KBIF = 0;
            KBIE = 1;
            //ǰر AD ʹܻж
            P11D = 1;
            Nop();
            Nop();
            Stop();
            Nop();
            Nop();
            KBIE = 0;
            KBIF = 0;
            GIE = 1;
            //ѺʹرռжϣʵӦû
            P11D = 0;
        }
    }
}

/************************************************
;  *    @Function Name       : interrupt
;  *    @Description         : жϺ
;  *    @IN_Parameter        : 
;  *    @Return parameter    :
;  ***********************************************/
void int_isr(void) __interrupt
{
    __asm 
    movra _abuf   
    swapar _PFLAG
    movra _statusbuf
    __endasm;


    if (T1IF & T1IE)
    {
        T1IF = 0;
        timer1_cnt1++;
        if (timer1_cnt1 >= 5000)       //5s
        {
            timer1_cnt1 = 0;
            FLAG_TIMER1_5000MS = 1;
        }
    }
    __asm 
    swapar _statusbuf
    movra _PFLAG
    swapr _abuf
    swapar _abuf
    __endasm;
}

/**************************** end of file *********************************************/

