/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC30P6280B
;  *   	@             : 2025.08.01
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	   	T0ʱ5sһ P10жϻ
   	   	   	   	   	   	P11ж1mSת
******************************************************************************/


#include "user.h"

/************************************************
;  *    @Function Name       : C_RAM
;  *    @Description         : ʼRAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void C_RAM(void)
{
   	__asm
   	movai 0x3F
   	movra FSR
   	movai 47
   	movra 0x3F
   	decr FSR
   	clrr INDF
   	djzr 0x3F
   	goto $ -3;
   	clrr 0x3F
   	__endasm;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         :
;  *    @IN_Parameter      	 :
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
   	P1 = 0x00; //1:input 0:output
   	DDR1 = 0x00;   	//1:input 0:output
   	PUCON = 0xff; //0:Effective 1:invalid
   	PDCON = 0xff; //0:Effective 1:invalid
   	ODCON = 0x00; //0:  1:©
}
/************************************************
;  *    @Function Name       : KBIE_Init
;  *    @Description         : ж
;  *    @IN_Parameter      	 :
;  *    @Return parameter    :
;  ***********************************************/
void KBIE_Init(void)
{
   	DDR1 |= DEF_SET_BIT0;  	//P10  in
   	PUCON &= ~DEF_SET_BIT0;	//P10
   	P1KBCR |= DEF_SET_BIT0;    	//ʹP10ļжλ
}
/************************************************
 ;  *    @Function Name       : TIMER0_INT_Init
 ;  *    @Description         : 
 ;  *    @IN_Parameter        :
 ;  *    @Return parameter    :
 ;  ***********************************************/
void TIMER0_INT_Init(void)
{
   	T0CR = 0x05; //ʱΪCPUʱ    ʱ64Ƶ  1ms
   	T0CNT = 256 - 125;
   	T0IE = 1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
   	GIE = 0;
   	C_RAM();
   	IO_Init();
   	KBIE_Init();
   	TIMER0_INT_Init();
   	GIE = 1;
}
//=================================================================================
void main(void)
{
   	Sys_Init();
   	while (1)
   	{
     	   	if(FLAG_TIMER0_5000ms)
     	   	{
     	   	   	FLAG_TIMER0_5000ms=0;
     	   	   	GIE = 0;
     	   	   	KBIF=0;
     	   	   	KBIE = 1;
     	   	   	P11D = 0;
     	       	Stop();
     	   	   	Nop();
     	   	   	Nop();
     	   	   	KBIE = 0;
     	   	   	KBIF = 0;
     	   	   	P11D = 1;
     	   	   	GIE = 1;   	   	
     	   	}
   	}
}

/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter          	 :
;  *    @Return parameter      	:
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm
   	movra _abuf
   	swapar _STATUS
   	movra _statusbuf
__endasm;

   	if((T0IF)&&(T0IE))
    {
   	   	T0CNT=131;
   	   	P11D=!P11D;
   	   	timer0_count1++;
   	   	if(timer0_count1>=5000)
   	   	{
   	   	   	timer0_count1=0;
   	   	   	FLAG_TIMER0_5000ms=1;      	   	   	
   	   	}
   	   	T0IF=0;
    }
__asm
   	swapar _statusbuf
   	movra _STATUS
   	swapr _abuf
   	swapar _abuf
__endasm;
}


/**************************** end of file *********************************************/
