/******************************************************************************
;  *   	@ͺ	   	   	   	  : MC30P6280B
;  *   	@             : 2025.08.01
;  *   	@˾/ 	   	   	  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *   	   	   	   	   	TIME  ʱʹ
   	   	   	   	   	   	T0 	1mSж  P14ת
   	   	   	   	   	   	T1 	100uSж P12ת
******************************************************************************/


#include "user.h"

/************************************************
;  *    @Function Name       : C_RAM
;  *    @Description         : ʼRAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void C_RAM(void)
{
   	__asm
   	movai 0x3F
   	movra FSR
   	movai 47
   	movra 0x3F
   	decr FSR
   	clrr INDF
   	djzr 0x3F
   	goto $ -3;
   	clrr 0x3F
   	__endasm;
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         :
;  *    @IN_Parameter      	 :
;  *    @Return parameter    :
;  ***********************************************/
void IO_Init(void)
{
   	P1 = 0x00; //1:input 0:output
   	DDR1 = 0x08;   	//1:input 0:output
   	PUCON = 0xff; //0:Effective 1:invalid
   	PDCON = 0xff; //0:Effective 1:invalid
   	ODCON = 0x00; //0:  1:©
   	P13D=1;
}
/************************************************
 ;  *    @Function Name       : TIMER0_INT_Init
 ;  *    @Description         : 
 ;  *    @IN_Parameter        :
 ;  *    @Return parameter    :
 ;  ***********************************************/
void TIMER0_INT_Init(void)
{
   	T0CR = 0x05; //ʱΪCPUʱ    ʱ64Ƶ  1ms
   	T0CNT = 256 - 125;
   	T0IE = 1;
}
/************************************************
 ;  *    @Function Name       : TIMER1_INT_Init
 ;  *    @Description         : 
 ;  *    @IN_Parameter        :
 ;  *    @Return parameter    :
 ;  ***********************************************/
void TIMER1_INT_Init(void)
{
   	T1CR = 0x03;   	   	//Fcpu 8Ƶ 	
   	T1CNT = 100-1;
   	T1LOAD = 100-1;	   	//100uS
   	T1EN = 1;
   	T1IE = 1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/
void Sys_Init(void)
{
   	GIE = 0;
   	C_RAM();
   	IO_Init();
   	TIMER0_INT_Init();
   	TIMER1_INT_Init();
   	GIE = 1;
}
//=================================================================================
void main(void)
{
   	Sys_Init();
   	while (1)
   	{
   	   	
   	   
   	}
}

/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter          	 :
;  *    @Return parameter      	:
;  ***********************************************/
void int_isr(void) __interrupt
{
__asm
   	movra _abuf
   	swapar _STATUS
   	movra _statusbuf
__endasm;

   	if ((T0IF) && (T0IE))
   	{
   	   	T0IF = 0;
   	   	T0CNT = 256 - 125;
   	   	P14D = !P14D;
   	}

   	if ((T1IF) && (T1IE))
   	{
   	   	T1IF = 0;
   	   	P12D = !P12D;
   	}
__asm
   	swapar _statusbuf
   	movra _STATUS
   	swapr _abuf
   	swapar _abuf
__endasm;
}


/**************************** end of file *********************************************/