/******************************************************************************
;  *   	@ͺ				  : MC30P6201
;  *   	@             : 2021.08.04
;  *   	@˾/			  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *			                ģPWM     
							P10     500HZ  80%
							P11     500HZ  50%
							P12     500HZ  30%
							P14     1KHZ   80%
							P15     1KHZ   50%                              
							//ɸдԼram/rom                        		
******************************************************************************/
#include "user.h"
/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : ʼRAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/  
void CLR_RAM(void)
{      	       	
    __asm
           	movai  	0x40
           	movra  	FSR
           	movai  	48
           	movra  	0x07
           	decr   	FSR
           	clrr   	INDF
           	djzr   	0x07
           	goto   	$-3
           	clrr   	0x07
   	   	   	clrr   	0x05
    __endasm;          	
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : io  
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/ 
void IO_Init(void)
{  	   	   	   	
   	P1 = 0x00;     	
   	DDR1 = 0x00;     //1:input 0:output    	   	
   	PDCON = 0xff;  	//0:Effective 1:invalid
   	PUCON = 0xff;  	//0:Effective 1:invalid 
}
/************************************************
;  *    @Function Name       : Timer_INT_Init
;  *    @Description         : ʱʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/  
void Timer_INT_Init(void)
{
   	T0CR=0x00;     //ʱΪCPUʱ    ʱ2Ƶ  
   	T0CNT=256-200;      //100us 
   	T0IE=1;
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/  
void  Sys_Init(void)
{
   	GIE = 0;
   	CLR_RAM();
   	IO_Init();
   	Timer_INT_Init();   
   	GIE  = 1;        
}
/************************************************
;  *    @Function Name       : PWMT_Config
;  *    @Description         : PWM
;  *    @IN_Parameter      	 :
;  *    @Return parameter    :
;  ***********************************************/
void PWMT_Config(uint8_t PWM0T,uint8_t PWM1T)
{
    PWM0_TDR=PWM0T;
    PWM1_TDR=PWM1T;
}
/************************************************
;  *    @Function Name       : main
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/  
void main (void)
{    
   	Sys_Init();
    PWMT_Config(PWM0_T_DEF,PWM1_T_DEF);        //
    PWM0_CH0_DDR=16;
    PWM0_CH1_DDR=10;
    PWM0_CH2_DDR=6;
    PWM1_CH0_DDR=8;
    PWM1_CH1_DDR=5;         //ռձ
   	while(1)
   	{  	   	
   	}   
}
/************************************************
;  *    @Function Name       : Interrupt
;  *    @Description         : The interrupt function
;  *    @IN_Parameter          	 :
;  *    @Return parameter      	:
;  ***********************************************/        
void int_isr(void)__interrupt
{
__asm
   	movra   _abuf
    swapar  _STATUS
    movra   _statusbuf
__endasm;

    if((T0IF)&&(T0IE))
    {
   	   	T0CNT=256-200;
        timer0_num1++;
        timer0_num2++;
   	   	if(timer0_num1>=PWM0_TDR)//ģPWM
   	   	{
   	   	   	timer0_num1=0;          //ﵽ 0
   	   	}
        if(timer0_num2>=PWM1_TDR)//ģPWM
   	   	{
   	   	   	timer0_num2=0;      //ﵽ 0
   	   	}     

   	   	if(timer0_num1<PWM0_CH0_DDR)    //ﵽռձ  ת
   	   	{
   	   	    PWM0_IO_CH0ON;
   	   	}
   	   	else PWM0_IO_CH0OFF;
        if(timer0_num1<PWM0_CH1_DDR)    //ﵽռձ  ת
   	   	{
   	   	    PWM0_IO_CH1ON;
   	   	}
   	   	else PWM0_IO_CH1OFF;
        if(timer0_num1<PWM0_CH2_DDR)    //ﵽռձ  ת
   	   	{
   	   	    PWM0_IO_CH2ON;
   	   	}
   	   	else PWM0_IO_CH2OFF;
        if(timer0_num2<PWM1_CH0_DDR)    //ﵽռձ  ת
   	   	{
   	   	    PWM1_IO_CH0ON;
   	   	}
   	   	else PWM1_IO_CH0OFF;
        if(timer0_num2<PWM1_CH1_DDR)    //ﵽռձ  ת
   	   	{
   	   	    PWM1_IO_CH1ON;
   	   	}
   	   	else PWM1_IO_CH1OFF;
			  
	   	T0IF=0;
    }
__asm
    swapar  _statusbuf
    movra   _STATUS
    swapr   _abuf
    swapar  _abuf
__endasm;
}



/**************************** end of file *********************************************/

