/******************************************************************************
;  *   	@ͺ				  : MC30P6240
;  *   	@             : 2021.08.04
;  *   	@˾/			  : SINOMCU-FAE
;  *   	@΢֧       : 2048615934
;  *   	@΢           : http://www.sinomcu.com/
;  *   	@Ȩ                 : 2021 SINOMCU˾Ȩ.
;  *----------------------ժҪ---------------------------------
;  *    1   V1.0     2019.03.18	   	   	P16 1msת P10.11.12.15PWM
   	   	   	   	   	   	   	   	   	   	5s  P17
  ******************************************************************************/

#include "user.h"


/************************************************
;  *    @Function Name       : CLR_RAM
;  *    @Description         : ʼRAM
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/  
void CLR_RAM(void)
{      	       	
    __asm
           	movai  	0x40
           	movra  	FSR
           	movai  	48
           	movra  	0x07
           	decr   	FSR
           	clrr   	INDF
           	djzr   	0x07
           	goto   	$-3
           	clrr   	0x07
    __endasm;          	
}

/************************************************
;  *    @Function Name       : IO_Init
;  *    @Description         : io 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/ 
void IO_Init(void)
{
   	P0 = 0x00; 	   	   	   	
   	P1 = 0x00;
   	DDR0 = 0x00;   	//1:input 0:output
   	DDR1 = 0x00;       	   	
   	PUDCON = 0xff;     	//0:Effective 1:invalid
   	PUCON = 0xff;  	//0:Effective 1:invalid 
   	ODCON = 0x00;  	   	//0:  1:© 
}
/************************************************
;  *    @Function Name       : TIMER0_INT_Init
;  *    @Description         : 
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/ 
void TIMER0_INT_Init(void)
{
   	T0CR=0x05;     //ʱΪCPUʱ    ʱ64Ƶ  1ms
   	T0CNT=256-125;
   	T0IE=1;
}
/************************************************
;  *    @Function Name       : TIMER1_PWM_Init
;  *    @Description         : 
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void TIMER1_PWM_Init(void)
{
   	T1LOAD=99;     	   	   	//12.5us
   	T1CNT=99;
   	PWMCR0=0x63;
   	PWMCR1=0x03;
   	T1DATA=10;         	
   	T1DATB=20;
   	T1DATC=30;
   	T1DATD=40;
   	T1CR=0xc0; 	//T1ʱCPUƵ
}
/************************************************
;  *    @Function Name       : KBIE_Init
;  *    @Description         : 
;  *    @IN_Parameter        :
;  *    @Return parameter    :
;  ***********************************************/
void KBIE_Init(void)
{
   	DDR1 = 0x80;       	   	//P17  in
   	PUCON=0x7f;        	   	//P17 
   	P1KBCR=0x80;       	   	   	//ʹP17ļжλ
}
/************************************************
;  *    @Function Name       : Sys_Init
;  *    @Description         : ϵͳʼ
;  *    @IN_Parameter      	 : 
;  *    @Return parameter    :
;  ***********************************************/  
void Sys_Init(void)
{
   	GIE = 0;
   	CLR_RAM();
   	IO_Init();
   	TIMER0_INT_Init();
   	TIMER1_PWM_Init();
   	KBIE_Init();
   	GIE  = 1;        
}
void main (void)
{    
   	Sys_Init();
   	while(1)
   	{  	 
   	   	if(FLAG_TIMER0_5000ms) 	   	//5s
   	   	{
   	   	   	FLAG_TIMER0_5000ms=0;
   	   	   	GIE = 0;
   	   	   	KBIF=0;
   	   	   	KBIE = 1;
   	   	   	P16D=0;
   	   	   	T1EN=0;
   	   	   	PWM1AEN=0;
   	   	   	PWM1BEN=0;
   	   	   	PWM1CEN=0;
   	   	   	PWM1DEN=0; 	   	 //ر
   	   	   	Nop();
   	   	   	Nop();
   	       	Stop();
   	   	   	Nop();
   	   	   	Nop();
   	   	   	KBIE = 0;
   	   	   	KBIF = 0;
   	   	   	GIE = 1;
   	   	   	T1EN=1;
   	   	   	PWM1AEN=1;
   	   	   	PWM1BEN=1;
   	   	   	PWM1CEN=1;
   	   	   	PWM1DEN=1;    //
   	   	}
   	}   
}   
void int_isr(void)__interrupt
{
   	__asm
   	   	movra   _abuf
    swapar  _STATUS
    movra   _statusbuf
__endasm;

    if((T0IF)&&(T0IE))
    {
       	T0CNT=256-125;
   	   	P16D=!P16D; 
       	
   	   	timer0_count1++;
   	   	if(timer0_count1>=5000)
   	   	{
   	   	   	timer0_count1=0;
   	   	   	FLAG_TIMER0_5000ms=1;
   	   	}
   	   	T0IF=0;
    }
__asm
       	swapar  _statusbuf
    movra   _STATUS
    swapr   _abuf
    swapar  _abuf
__endasm;
}


