/*
 * ---------------------------------------------------------------------
 * Copyright (C) 2019 SINOMCU
 * All Rights Reserved
 * ---------------------------------------------------------------------
 * filename: tkm_debug.h
 * version:  v1.0.0
 * author:   zyx and yj
 * date:     2019/12/11
 * The file is only for SINOMCU MC51F8114 product.
 * ---------------------------------------------------------------------
 */
#ifndef __TKM_DEBUG_H__
#define __TKM_DEBUG_H__
/********************************************************************
* Includes
********************************************************************/
#include "mc51f.h"
#include "tkm_config.h"

/********************************************************************
* Public Macros and struct
********************************************************************/
/* TK与PC通讯功能模块（占用UART资源） */
#define UART_PC_COMMUNICATEFUNCTION OFF      // 通过上位机工具将触摸库数据（采样值、滤波值、基准值绘制为波形）ON/ OFF

#if UART_PC_COMMUNICATEFUNCTION == ON
struct TKM_COMMUNICATE // 触摸库与上位机通信的结构体
{
  uchar uchReceiveDataStatus;                // 接收数据的状态
  uchar uchCorrectDataLength;                // 当前状态需要接收的数据长度
  uchar uchlength;                           // 数据长度
  uchar uchrp;                               // 数组指针
  uchar uchtp;                               // 发送指针
  uchar uchUploadSampByte[(TK_NUM * 2) + 6]; // 采样数据字节
  uchar uchUploadRawByte[(TK_NUM * 2) + 6];  // 滤波数据字节
  uchar uchUploadBaseByte[(TK_NUM * 2) + 6]; // 基线数据字节
  uchar uchUploadBuf[(TK_NUM * 2) + 6];      // 发送缓冲区
  uchar uchReceiveBuf[4];                    // 接收PC数据buf
};
#endif

/********************************************************************
* Public variables
********************************************************************/
extern uint xdata TK_value_origin[TK_NUM];         // 采样值
extern uint xdata TK_value_filter[TK_NUM];         // 滤波值
extern uint xdata TK_value_average[TK_NUM];        // 基准值
#if UART_PC_COMMUNICATEFUNCTION == ON
extern struct TKM_COMMUNICATE xdata g_tCommunicate;
#endif

/********************************************************************
* Public functions
********************************************************************/
void tkm_DebugInit(void);
void UART_Init(void);
void UartPC_CommunicateInit(void);
void SendPCData(void);
void ReceivePCData(void);
void GetUploadData(void);
#endif