/*
 * ---------------------------------------------------------------------
 * Copyright (C) 2019 SINOMCU
 * All Rights Reserved
 * ---------------------------------------------------------------------
 * filename: main.c
 * verion:   v1.0.2
 * author:   zyx and yj
 * date:     2019/12/11
 * The file is only for SINOMCU MC51F8114 product.
 * ---------------------------------------------------------------------
 */
/********************************************************************
* Includes
********************************************************************/
#include "main.h"

/********************************************************************
* Macros and Definitions
********************************************************************/


/********************************************************************
* Private variables
********************************************************************/


/********************************************************************
* Private functions
********************************************************************/
/*********************************************************
: void main(void)
  : 
ֵ: 
ֵ: 
**********************************************************/
void main(void)
{
  MCUInit();
  Buzzer_Init();
  TKInit();
  TMR0_Init();
  Int_PriorityInit();
  while (1)
  {
    clr_WDT;
    Tk_service();
    App_Process();
  }
}

/***********************************************************
: void MCUInit(void)
  : ϵͳʼӳ
ֵ: 
ֵ: 
**********************************************************/
void MCUInit(void)
{
  WDT_init(); //WDTʼ
  IO_Init();
}

/***********************************************************
: void Int_PriorityInit(void)
  : жȼʼӳ
ֵ: 
ֵ: 
**********************************************************/
void Int_PriorityInit(void)
{
  INTn_IP = 0;
  INT2_IP = 1;            //timerж
  INT3_IP = 1;
}

/*********************************************************
: void WDT_init(void)
  : Źʼ
ֵ: 
ֵ: 
**********************************************************/
void WDT_init(void)
{
  WDT_LRC_128MS; //128ms
  CLR_WDT;
}

/*********************************************************
:	void TMR0_Init(void) 
  :	TMR ʼӳ(ʱ300ms)
ֵ: 
ֵ: 
**********************************************************/
void TMR0_Init() 
{
	//ʹTMRжʹܣ
	TMR0_INT_EN;
	//TMR8λ - ʼΪ0
	TMR0_CLR;
	//TMRڼĴ
	TMR0_CYL = (uchar)599;
  TMR0_CYH = (uchar)599 >> 8;
	//LRC16Kʱ
	TMR0_LRC;
	//8Ƶ
	TMR0_DIV8_EN;
	//TMR-ʹ
	TMR0_EN;
  INT2_EN;	
}

/***********************************************************
: void IO_Init(void)
  : IO˿ڳʼӳ
ֵ: 
ֵ: 
**********************************************************/
void IO_Init(void)
{
  P0_CLR;
  P1_CLR;
  P2_CLR;
  
  P0_OUT_EN;
  P1_OUT_EN;
  P2_OUT_EN;
}

/*********************************************************
: void Buzzer_Init(void)
  : ʼϵʱһ
ֵ: 
ֵ: 
**********************************************************/
void Buzzer_Init(void)
{
  BUZZER = ON;
  Delaytime(30000);
  BUZZER = OFF;
}

/*********************************************************
: void App_Process(void)
  : ݴİӦûԶ壬齫TK_state
        ֵʱͨʱжϽаӦ
        LEDƵͷУ
ֵ: 
ֵ: 
**********************************************************/
void App_Process(void)
{
  uchar i = 0;
  uint TK_state_temp;
  TK_state_temp = TK_state;
  for (i = 0; i < TK_NUM; i++)
  {
    switch (i)
    {
    case 0:
      if (TK_state_temp & ((uint)1 << i)) 
      {// һLED
        LED0 = LED_ON;
        BUZZER = BUZZER_ON;
        TMR0_EN;
      }
      else
      {
        LED0 = LED_OFF;
      }
      break;
    case 1:
      if (TK_state_temp & ((uint)1 << i)) 
      {// ڶLED
        LED1 = LED_ON;
        BUZZER = BUZZER_ON;
        TMR0_EN;
      }
      else
      {
        LED1 = LED_OFF;
      }
      break;
    case 2:
      if (TK_state_temp & ((uint)1 << i))
      {// LED
        LED2 = LED_ON;
        BUZZER = BUZZER_ON;
        TMR0_EN;
      }
      else
      {
        LED2 = LED_OFF;
      }
      break;
    case 3:
      if (TK_state_temp & ((uint)1 << i)) 
      {// ĸLED
        LED3 = LED_ON;
        BUZZER = BUZZER_ON;
        TMR0_EN;
      }
      else
      {
        LED3 = LED_OFF;
      }
      break;
    case 4:
      if (TK_state_temp & ((uint)1 << i)) 
      {// LED
        LED4 = LED_ON;
        BUZZER = BUZZER_ON;
        TMR0_EN;
      }
      else
      {
        LED4 = LED_OFF;
      }
      break;
    case 5:
      if (TK_state_temp & ((uint)1 << i)) 
      {// LED
        LED5 = LED_ON;
        BUZZER = BUZZER_ON;
        TMR0_EN;
      }
      else
      {
        LED5 = LED_OFF;
      }
      break;
    default:
      break;
    }
  }
}