/*
 * ---------------------------------------------------------------------
 * Copyright (C) 2019 SINOMCU
 * All Rights Reserved
 * ---------------------------------------------------------------------
 * filename: tkm_config.c
 * verion:   v1.0.3
 * author:   zyx and yj
 * date:     2019/12/23
 * The file is only for SINOMCU MC51F8114 product.
 * ---------------------------------------------------------------------
 */

/********************************************************************
* Includes
********************************************************************/
#include "tkm_config.h"
#include "tkm_debug.h"

/********************************************************************
* Macros and Definitions
********************************************************************/


/********************************************************************
* Private variables
********************************************************************/
/* TK */
#if TK_NUM == 1
const uchar Channel_table[TK_NUM]  = {TK_Channel0};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0};
#elif TK_NUM == 2
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1};
#elif TK_NUM == 3
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2};
#elif TK_NUM == 4
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3};
#elif TK_NUM == 5
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4};
#elif TK_NUM == 6
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4, TK_Channel5};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4, TK_Threshold_Channel5};
#elif TK_NUM == 7
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4, TK_Channel5, TK_Channel6};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4, TK_Threshold_Channel5, TK_Threshold_Channel6};
#elif TK_NUM == 8
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4, TK_Channel5, TK_Channel6, TK_Channel7};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4, TK_Threshold_Channel5, TK_Threshold_Channel6, TK_Threshold_Channel7};
#elif TK_NUM == 9
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4, TK_Channel5, TK_Channel6, TK_Channel7, TK_Channel8};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4, TK_Threshold_Channel5, TK_Threshold_Channel6, TK_Threshold_Channel7, TK_Threshold_Channel8};
#elif TK_NUM == 10
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4, TK_Channel5, TK_Channel6, TK_Channel7, TK_Channel8, TK_Channel9};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4, TK_Threshold_Channel5, TK_Threshold_Channel6, TK_Threshold_Channel7, TK_Threshold_Channel8, TK_Threshold_Channel9};
#elif TK_NUM == 11
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4, TK_Channel5, TK_Channel6, TK_Channel7, TK_Channel8, TK_Channel9, TK_Channel10};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4, TK_Threshold_Channel5, TK_Threshold_Channel6, TK_Threshold_Channel7, TK_Threshold_Channel8, TK_Threshold_Channel9, TK_Threshold_Channel10};
#elif TK_NUM == 12
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4, TK_Channel5, TK_Channel6, TK_Channel7, TK_Channel8, TK_Channel9, TK_Channel10, TK_Channel11};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4, TK_Threshold_Channel5, TK_Threshold_Channel6, TK_Threshold_Channel7, TK_Threshold_Channel8, TK_Threshold_Channel9, TK_Threshold_Channel10, TK_Threshold_Channel11};
#elif TK_NUM == 13
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4, TK_Channel5, TK_Channel6, TK_Channel7, TK_Channel8, TK_Channel9, TK_Channel10, TK_Channel11, TK_Channel12};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4, TK_Threshold_Channel5, TK_Threshold_Channel6, TK_Threshold_Channel7, TK_Threshold_Channel8, TK_Threshold_Channel9, TK_Threshold_Channel10, TK_Threshold_Channel11, TK_Threshold_Channel12};
#elif TK_NUM == 14
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4, TK_Channel5, TK_Channel6, TK_Channel7, TK_Channel8, TK_Channel9, TK_Channel10, TK_Channel11, TK_Channel12, TK_Channel13};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4, TK_Threshold_Channel5, TK_Threshold_Channel6, TK_Threshold_Channel7, TK_Threshold_Channel8, TK_Threshold_Channel9, TK_Threshold_Channel10, TK_Threshold_Channel11, TK_Threshold_Channel12, TK_Threshold_Channel13};
#elif TK_NUM == 15
const uchar Channel_table[TK_NUM]  = {TK_Channel0, TK_Channel1, TK_Channel2, TK_Channel3, TK_Channel4, TK_Channel5, TK_Channel6, TK_Channel7, TK_Channel8, TK_Channel9, TK_Channel10, TK_Channel11, TK_Channel12, TK_Channel13, TK_Channel14};
const uint Threshold_table[TK_NUM] = {TK_Threshold_Channel0, TK_Threshold_Channel1, TK_Threshold_Channel2, TK_Threshold_Channel3, TK_Threshold_Channel4, TK_Threshold_Channel5, TK_Threshold_Channel6, TK_Threshold_Channel7, TK_Threshold_Channel8, TK_Threshold_Channel9, TK_Threshold_Channel10, TK_Threshold_Channel11, TK_Threshold_Channel12, TK_Threshold_Channel13, TK_Threshold_Channel14};
#endif

/* ر */
uint xdata TK_value_origin[TK_NUM];         // ֵ
uint xdata TK_value_filter[TK_NUM];         // ˲ֵ
uint xdata TK_value_average[TK_NUM];        // ׼ֵ
uint xdata TK_state;
uint const TK_Config_value[] = {TK_Samples_perscan,       // ۼ趨3--16 16λ
                                TK_BaseSamples_perscan,   // ߸ 趨1--65535 12
                                TK_Debounce_press,        // 8-12 ³趨
                                TK_Debounce_release,      // 8-12 ɿ趨
                                TK_Threshold_release,     // µĴ趨(1~255)
                                TK_Threshold_press,       // 뿪Ĵ趨 (1~255)
                                TK_Filter_lst_Increase,   // ˲ϵ (1~255)
                                TK_Average_lst_Increase}; // ׼ϵ (1~255)

/*±ڲҪ벻Ҫ޸Ļɾ,
  ޸ĻɾܻᵼTKг߱*/
uint  xdata g_unFirstFilterValue[TK_NUM];
int   xdata g_nFirstFilterDValue[TK_NUM];
uchar xdata TK_press_table[TK_NUM];
uchar xdata TK_release_table[TK_NUM];
uint  xdata Tk_Value_threshold_tmep[TK_NUM];
uchar xdata TK_FilterRatioConst[TK_NUM];
uchar xdata TK_AverageRatioConst[TK_NUM];

                                
/********************************************************************
* Private functions
********************************************************************/
static void Delaytime(uint time); //ʱӳ(Ǿ׼)


/*
*********************************************************
: void TKInit(void)
  : ʼӳ
ֵ
ֵ: 
**********************************************************
extern void TKInit(void);

*********************************************************
: void Tk_getbaselinedata(void)
  : ϵȡʼ˲ֵͻֵ(úǿи˲ֵͻ׼ֵ)
ֵ: 
ֵ: 
*********************************************************
extern void Tk_getbaselinedata(void);

*********************************************************
: void Tk_service(void)
  : TK
ֵ: 
ֵ: 
*********************************************************
extern void Tk_service(void);

*********************************************************
: void TKIntProcess(void)
  : TKжϴ
ֵ: 
*********************************************************
extern void TKIntProcess(void);

**********************************************************
: void TK_Config_Init(uchar uchTknum, uchar uchTK_VTKS, uchar uchTK_VRFS, uchar uchTK_CKS, uchar uchTK_DIV_SEL, uchar uchTK_FLT)
  : òʼ
ֵ uchTknum     TKͨ
        uchTK_VTKS   TKģѡ׼Դ
        uchTK_VRFS   TKֵѡ
        uchTK_CKS    TK ɨʱԴѡ
        uchTK_DIV_SELTK ɨʱӷƵ
        uchTK_FLT    TK˲ʱ
ֵ: 
*********************************************************
extern void TK_Config_Init(uchar uchTknum, uchar uchTK_VTKS, uchar uchTK_VRFS, uchar uchTK_CKS, uchar uchTK_DIV_SEL, uchar uchTK_FLT);
*/


/*********************************************************
: void TKInit(void)
  : ʼӳ
ֵ
ֵ: 
**********************************************************/
void TKInit(void)
{
  VREF_C = 0x80;
  Delaytime(2000);
#if UART_PC_COMMUNICATEFUNCTION == ON
  tkm_DebugInit();
#endif
  TK_Config_Init(TK_NUM, TK_VTKS_VREF, TK_VRFS_1p6V, TK_CKS_SYS, TK_DIV_SEL, TK_FLT_SEL);
  TK_Interrupt_EN();
  Delaytime(2000);
  Tk_getbaselinedata();
}

/*********************************************************
: void TK_Interrupt_EN(void)
  : TKжϳʼʹ
ֵ: 
ֵ: 
**********************************************************/
void TK_Interrupt_EN(void)
{
  INTn_IF = 0;
  INT4_IF = 0;   //ж
  GIE = 1;       //жʹ
  INT4_EN;       //ʹܴж
  AN_IE |= 0x01; //ʹTKж
}

/* Interface for Customer */
/*********************************************************
  : void Customer_Keystatejustpress(void)
  : ͨոռ⵽״̬
ֵ: 
ֵ: TK_state
**********************************************************/
void Customer_Keystatejustpress(void)
{ /* TK_state was just freshed  you can use the  parameter as you want */
}

/*********************************************************
  : void Customer_Keystatejustrelease(void)
  : ͨոռ⵽ͷ
ֵ: 
ֵ: TK_state
**********************************************************/
void Customer_Keystatejustrelease(void)
{ /* TK_state was just freshed  you can use the  parameter as you want */
}

/*********************************************************
  : void Customer_Tkdataready(void)
  : ݸոһθ
ֵ: 
ֵ: 
**********************************************************/
void Customer_Tkdataready(void)
{ /* Here for completely once data scan  the parameters  was refreshed here
     TK_value_origin[], TK_value_filter[], TK_value_average[] */
}

/*********************************************************
  : void Customer_Tkdatareadytoupdate(void)
  : ݸողϣ׼
ֵ: 
ֵ: 
**********************************************************/
void Customer_Tkdatareadytoupdate(void)
{ /* TK_value_origin[], TK_value_filter[], TK_value_average[] */
#if UART_PC_COMMUNICATEFUNCTION == ON
  GetUploadData();
#endif
}

/*********************************************************
  : void Delaytime(uint q)
  : ʱӳ
ֵ: 
ֵ: 
**********************************************************/
void Delaytime(uint q)
{
  uint i, j;
  for (i = 0; i < q; i++)
  {
    for (j = 0; j < 10; j++)
    {
      WDT_OP = 0x5A; //WDT
    }
  }
}
