/*
 * ---------------------------------------------------------------------
 * Copyright (C) 2019 SINOMCU
 * All Rights Reserved
 * ---------------------------------------------------------------------
 * filename: main.h
 * version:  v1.0.2
 * author:   zyx and yj
 * date:     2019/12/11
 * The file is only for SINOMCU MC51F8114 product.
 * ---------------------------------------------------------------------
 */

#ifndef __MAIN_H__
#define __MAIN_H__

/********************************************************************
* Includes
********************************************************************/
#include "mc51f.h"
#include "tkm_config.h"
#include "tkm_debug.h"
/********************************************************************
* Public Macros and struct
********************************************************************/
#define clr_WDT {WDT_OP = 0x5a;}

#define BUZZER_Function ON // 根据TK按键触发，蜂鸣器鸣叫 ON/ OFF
#define LED_Function    ON // 根据TK按键触发，点亮LED灯 ON/ OFF

#define BUZZER P1_3 // 蜂鸣器端口P1_3
#define LED0   P0_1 // TK按键触发，对应的IO端口输出高或低从而点亮LED灯
#define LED1   P0_2
#define LED2   P1_0
#define LED3   P0_7
#define LED4   P1_4
#define LED5   P1_5

#if BUZZER_Function == ON
#define BUZZER_ON 1 // 蜂鸣器鸣叫
#else
#define BUZZER_ON 0 // 蜂鸣器不鸣叫
#endif
#define BUZZER_OFF 0

#if LED_Function == ON
#define LED_ON 1 // 点亮LED灯
#else
#define LED_ON 0 // 不点亮LED灯
#endif
#define LED_OFF 0 // 0/1

/********************************************************************
* Public variables
********************************************************************/


/********************************************************************
* Public functions
********************************************************************/
void MCUInit(void);
void WDT_init(void);
void IO_Init(void);
void TMR0_Init();
void Int_PriorityInit(void);
void Buzzer_Init(void);
void App_Process(void);
#endif
