/*
 * ---------------------------------------------------------------------
 * Copyright (C) 2019 SINOMCU
 * All Rights Reserved
 * ---------------------------------------------------------------------
 * filename: tkm_config.h
 * version:  v1.0.3
 * author:   zyx and yj
 * date:     2020/03/06
 * The file is only for SINOMCU MC51F8114 product.
 * ---------------------------------------------------------------------
 */

#ifndef __TKM_CONFIG_H__
#define __TKM_CONFIG_H__

/********************************************************************
* Includes
********************************************************************/
#include "mc51f.h"

/********************************************************************
* Public Macros and struct
********************************************************************/
/* ز */
#define TK_NUM                  6    //ذ1--15

#define TK_Channel0             TK1  //TK1--TK15 ӦTK
#define TK_Channel1             TK4
#define TK_Channel2             TK5
#define TK_Channel3             TK8
#define TK_Channel4             TK9
#define TK_Channel5             TK15
#define TK_Channel6
#define TK_Channel7
#define TK_Channel8
#define TK_Channel9
#define TK_Channel10
#define TK_Channel11
#define TK_Channel12
#define TK_Channel13
#define TK_Channel14

#define TK_Threshold_Channel0   240  // ֵƼΪָǰ˲ֵĲֵ50%~80% 
#define TK_Threshold_Channel1   240  //                                                  
#define TK_Threshold_Channel2   240  //                                                 
#define TK_Threshold_Channel3   240  //                                                
#define TK_Threshold_Channel4   240  //                                                
#define TK_Threshold_Channel5   240  //                                                  
#define TK_Threshold_Channel6   75   
#define TK_Threshold_Channel7   75   
#define TK_Threshold_Channel8   75   
#define TK_Threshold_Channel9   75   
#define TK_Threshold_Channel10  75   
#define TK_Threshold_Channel11  75   
#define TK_Threshold_Channel12  75   
#define TK_Threshold_Channel13  75   
#define TK_Threshold_Channel14  75   
                                     
#define TK_Samples_perscan      18   // ۼ趨Ƽ(10~20), 16 λ
#define TK_BaseSamples_perscan  30   // ׼ֵ´Ƽ(10~30)(1~60)
#define TK_Threshold_press      10   // 8-12 趨
#define TK_Threshold_release    10   // 8-12 ɿ趨
#define TK_Debounce_press       4    // µĴ趨Ƽ(3~5),(1~10)
#define TK_Debounce_release     3    // 뿪Ĵ趨Ƽ(3~5),(1~10)
#define TK_Filter_lst_Increase  32   // ˲ϵƼ(4~32), (1~64)
#define TK_Average_lst_Increase 16   // ׼ϵƼ(4~32), (1~64)
                                     
/*TouchKeĴ======================================ʼ======================================*/
/*TKģѡ׼Դ*/
#define TK_VTKS_VREF            0x40 // VREF2.5VΪTKģ׼Դ
#define TK_VTKS_VDD             0x00 // VDDΪTKģ׼Դ
                                        
/*TKֵѡ*/                       
#define TK_VRFS_2p0V            0x07 // TKֵѡ2V
#define TK_VRFS_1p6V            0x06 // TKֵѡ1.6V
#define TK_VRFS_1p4V            0x05 // TKֵѡ1.4V
#define TK_VRFS_1p2V            0x04 // TKֵѡ1.2V
#define TK_VRFS_1p0V            0x03 // TKֵѡ1.0V
#define TK_VRFS_0p8V            0x02 // TKֵѡ0.8V
#define TK_VRFS_0p6V            0x01 // TKֵѡ0.6V
#define TK_VRFS_0p2V            0x00 // TKֵѡ0.2V
                                        
/*TK ɨʱԴ TK_SRC ѡ*/            
#define TK_CKS_PWM0             0x03 // ѡ PWM0 
#define TK_CKS_HRC              0x02 // ѡ HRC
#define TK_CKS_LRC              0x01 // ѡ LRC
#define TK_CKS_SYS              0x00 // ѡϵͳʱ SYSCLK
                                        
/*TK ɨʱӷƵ*/                      
#define TK_DIV_SEL              0x01 // Χ:0~63  ʽFTKCLK = FTK_SRC/(TK_DIV_SEL + 1) x 2) 壺(TK_DIV_SEL+1)*2Ƶ
                                        
/*TK˲ʱ*/                           
#define TK_FLT_DIS              0    // رTK˲
#define TK_FLT_SEL              0x03 // Χ0~15 ʽTFLT = (TK_FLT_SEL + 1)/FTKCLK 壺TK˲ʱ  
/*TouchKeĴ============================================================================*/

/*±ڲ궨벻Ҫ޸Ļɾ,
  ޸ĻɾܻᵼTKг߱*/
#define TK1                     0x03
#define TK2                     0x05
#define TK3                     0x09
#define TK4                     0x11
#define TK5                     0x21
#define TK6                     0x41
#define TK7                     0x81
#define TK8                     0x01
#define TK9                     0x02
#define TK10                    0x04
#define TK11                    0x08
#define TK12                    0x10
#define TK13                    0x20
#define TK14                    0x40
#define TK15                    0x80



/********************************************************************
* Public variables
********************************************************************/
extern uint xdata TK_state;

/********************************************************************
* Public functions
********************************************************************/
/*********************************************************
: void TKInit(void)
  : ʼӳ
ֵ
ֵ: 
**********************************************************/
extern void TKInit(void);

/*********************************************************
: void Tk_getbaselinedata(void)
  : ϵȡʼ˲ֵͻֵ(úǿи˲ֵͻ׼ֵ)
ֵ: 
ֵ: 
**********************************************************/
extern void Tk_getbaselinedata(void);

/*********************************************************
: void Tk_service(void)
  : TK
ֵ: 
ֵ: 
**********************************************************/
extern void Tk_service(void);

/*********************************************************
: void TKIntProcess(void)
  : TKжϴ
ֵ: 
**********************************************************/
extern void TKIntProcess(void);

/*********************************************************
: void TK_Config_Init(uchar uchTknum, uchar uchTK_VTKS, uchar uchTK_VRFS, uchar uchTK_CKS, uchar uchTK_DIV_SEL, uchar uchTK_FLT)
  : òʼ
ֵuchTknum     TKͨ
        uchTK_VTKS   TKģѡ׼Դ
        uchTK_VRFS   TKֵѡ
        uchTK_CKS    TKɨʱԴѡ
        uchTK_DIV_SELTKɨʱӷƵ
        uchTK_FLT    TK˲ʱ
ֵ: 
**********************************************************/
extern void TK_Config_Init(uchar uchTknum, uchar uchTK_VTKS, uchar uchTK_VRFS, uchar uchTK_CKS, uchar uchTK_DIV_SEL, uchar uchTK_FLT);

extern void GetUploadData(void);
/*  */
void TK_Interrupt_EN(void);
void Delaytime(uint q);
/* Interface for Customer */
void Customer_Keystatejustpress(void);
void Customer_Keystatejustrelease(void);
void Customer_Tkdataready(void);
void Customer_Tkdatareadytoupdate(void);

#endif
