/*
 * ---------------------------------------------------------------------
 * Copyright (C) 2019 SINOMCU
 * All Rights Reserved
 * ---------------------------------------------------------------------
 * filename: int.c
 * verion:   v1.0.2
 * author:   zyx and yj
 * date:     2019/12/11
 * The file is only for SINOMCU MC51F8114 product.
 * ---------------------------------------------------------------------
 */
/********************************************************************
* Includes
********************************************************************/
#include "main.h"

/********************************************************************
* Macros and Definitions
********************************************************************/


/********************************************************************
* Private variables
********************************************************************/


/********************************************************************
* Private functions
********************************************************************/


/*********************************************************
函数名: void Int4Interrupt(void)
描  述: TK中断服务子程序
输入值: 无
输出值: 无
**********************************************************/
void Int4Interrupt(void) interrupt 9 //INT4
{
  TKIntProcess();
}

/*********************************************************
函数名:	void isr(void) interrupt
描  述:	定时器中断服务子程序
输入值: 无
输出值: 无
**********************************************************/
void Timer0() interrupt 7      //调用定时器中断
{	
	if(TMR0_IF)	   							 //定时器中断标志
  {
    TMR0_IF   =  0x00;
		BUZZER = BUZZER_OFF;
  }		
	INTn_IF  =  0; 
	TMR0_DIS;
}

/*********************************************************
函数名:	void Int3Interrupt()
描  述:	Uart中断服务子程序
输入值: 无
输出值: 无
**********************************************************/
void Int3Interrupt() interrupt 8 //INT3
{
#if UART_PC_COMMUNICATEFUNCTION == ON
  ReceivePCData();
  SendPCData();
#endif 
}